/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.ViburDataSource;
import org.vibur.dbcp.ViburMonitoring;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.ConnectionFactory;
import org.vibur.dbcp.pool.Connector;
import org.vibur.dbcp.pool.DefaultHook;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.pool.TakenConnection;
import org.vibur.dbcp.pool.TakenConnectionsFormatter;
import org.vibur.dbcp.pool.ViburListener;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.stcache.ClhmStatementCache;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.Listener;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class ViburDBCPDataSource
extends ViburConfig
implements ViburDataSource {
    private static final Logger logger = LoggerFactory.getLogger(ViburDBCPDataSource.class);
    private final AtomicReference<ViburDataSource.State> state = new AtomicReference<ViburDataSource.State>(ViburDataSource.State.NEW);
    private PoolOperations poolOperations;

    public ViburDBCPDataSource() {
    }

    public ViburDBCPDataSource(String configFileName) throws ViburDBCPException {
        URL config;
        if (configFileName != null) {
            config = this.getURL(configFileName);
            if (config == null) {
                throw new ViburDBCPException("Unable to load resource " + configFileName);
            }
        } else {
            config = this.getURL("vibur-dbcp-config.xml");
            if (config == null && (config = this.getURL("vibur-dbcp-config.properties")) == null) {
                throw new ViburDBCPException("Unable to load default resources from vibur-dbcp-config.xml or vibur-dbcp-config.properties");
            }
        }
        this.configureFromURL(config);
    }

    public ViburDBCPDataSource(Properties properties) throws ViburDBCPException {
        this.configureFromProperties(properties);
    }

    private URL getURL(String configFileName) {
        URL config = Thread.currentThread().getContextClassLoader().getResource(configFileName);
        if (config == null && (config = this.getClass().getClassLoader().getResource(configFileName)) == null) {
            config = ClassLoader.getSystemResource(configFileName);
        }
        return config;
    }

    private void configureFromURL(URL config) throws ViburDBCPException {
        InputStream inputStream = null;
        try {
            URLConnection uConn = config.openConnection();
            uConn.setUseCaches(false);
            inputStream = uConn.getInputStream();
            Properties properties = new Properties();
            if (config.getFile().endsWith(".xml")) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
            this.configureFromProperties(properties);
        }
        catch (IOException e) {
            throw new ViburDBCPException(config.toString(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.debug("Couldn't close configuration URL {}", (Object)config, (Object)e);
            }
        }
    }

    private void configureFromProperties(Properties properties) throws ViburDBCPException {
        HashSet<String> fields = new HashSet<String>();
        for (Field field : ViburConfig.class.getDeclaredFields()) {
            fields.add(field.getName());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!fields.contains(key)) {
                logger.warn("Ignoring unknown configuration property {}", (Object)key);
                continue;
            }
            try {
                Field field = ViburConfig.class.getDeclaredField(key);
                Class<?> type = field.getType();
                if (type == Integer.TYPE || type == Integer.class) {
                    this.set(field, Integer.parseInt(val));
                    continue;
                }
                if (type == Long.TYPE || type == Long.class) {
                    this.set(field, Long.parseLong(val));
                    continue;
                }
                if (type == Float.TYPE || type == Float.class) {
                    this.set(field, Float.valueOf(Float.parseFloat(val)));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    this.set(field, Boolean.parseBoolean(val));
                    continue;
                }
                if (type == String.class) {
                    this.set(field, val);
                    continue;
                }
                throw new ViburDBCPException(String.format("Unexpected type for configuration property %s/%s", key, val));
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new ViburDBCPException(String.format("Error setting configuration property %s/%s", key, val), e);
            }
        }
    }

    private void set(Field field, Object value) throws IllegalArgumentException, ReflectiveOperationException {
        String filedName = field.getName();
        String methodSetter = "set" + filedName.substring(0, 1).toUpperCase() + filedName.substring(1);
        Method setter = ViburConfig.class.getDeclaredMethod(methodSetter, field.getType());
        setter.invoke((Object)this, value);
    }

    @Override
    public void start() throws ViburDBCPException {
        try {
            this.doStart();
            logger.info("Started {}", (Object)this);
        }
        catch (IllegalStateException e) {
            throw new ViburDBCPException(e);
        }
        catch (IllegalArgumentException | NullPointerException | ViburDBCPException e) {
            logger.error("Unable to start {} due to:", (Object)this, (Object)e);
            this.terminate();
            throw e instanceof ViburDBCPException ? e : new ViburDBCPException(e);
        }
    }

    private void doStart() throws ViburDBCPException {
        ConcurrentPool pool;
        if (!this.state.compareAndSet(ViburDataSource.State.NEW, ViburDataSource.State.WORKING)) {
            throw new IllegalStateException();
        }
        this.validateConfig();
        if (this.getExternalDataSource() == null) {
            this.initJdbcDriver();
        }
        if (this.getConnector() == null) {
            this.setConnector(Connector.Builder.buildConnector(this, this.getUsername(), this.getPassword()));
        }
        this.initDefaultHooks();
        ViburObjectFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            connectionFactory = new ConnectionFactory(this);
            this.setConnectionFactory(connectionFactory);
        }
        if ((pool = this.getPool()) == null) {
            if (this.isPoolEnableConnectionTracking() && this.getTakenConnectionsFormatter() == null) {
                this.setTakenConnectionsFormatter(new TakenConnectionsFormatter.Default(this));
            }
            pool = new ConcurrentPool(this.getConcurrentCollection(), (PoolObjectFactory)connectionFactory, this.getPoolInitialSize(), this.getPoolMaxSize(), this.isPoolFair(), (Listener)(this.isPoolEnableConnectionTracking() ? new ViburListener(this) : null));
            this.setPool((PoolService<ConnHolder>)pool);
        }
        this.poolOperations = new PoolOperations(this, connectionFactory, (PoolService<ConnHolder>)pool);
        this.initPoolReducer();
        this.initStatementCache();
        if (this.isEnableJMX()) {
            ViburMonitoring.registerMBean(this);
        }
    }

    @Override
    public void terminate() {
        ViburDataSource.State oldState = this.state.getAndSet(ViburDataSource.State.TERMINATED);
        if (oldState == ViburDataSource.State.TERMINATED || oldState == ViburDataSource.State.NEW) {
            return;
        }
        if (this.getPool() != null) {
            this.getPool().terminate();
        }
        Object[] takenConnections = this.getTakenConnections();
        if (this.getPoolReducer() != null) {
            this.getPoolReducer().terminate();
        }
        if (this.getStatementCache() != null) {
            this.getStatementCache().close();
        }
        if (this.isEnableJMX()) {
            ViburMonitoring.unregisterMBean(this);
        }
        if (!this.isPoolEnableConnectionTracking()) {
            logger.info("Terminated {}", (Object)this);
        } else {
            logger.info("Terminated {}, remaining taken connections {}", (Object)this, (Object)Arrays.deepToString(takenConnections));
        }
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public ViburDataSource.State getState() {
        return this.state.get();
    }

    private void validateConfig() {
        ArgumentValidation.forbidIllegalArgument((this.getExternalDataSource() == null && this.getJdbcUrl() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryDelayInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryAttempts() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionTimeoutInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getLoginTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getStatementCacheMaxSize() < 0 && this.getStatementCache() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerTimeIntervalInSeconds() > 0 && this.getPoolReducerClass() == null && this.getPoolReducer() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerSamples() <= 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionIdleLimitInSeconds() >= 0 && this.getTestConnectionQuery() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getValidateTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.isUseNetworkTimeout() && this.getNetworkTimeoutExecutor() == null ? 1 : 0) != 0);
        Objects.requireNonNull(this.getCriticalSQLStates());
        if (this.getPassword() == null) {
            logger.warn("JDBC password is not specified.");
        }
        if (this.getUsername() == null) {
            logger.warn("JDBC username is not specified.");
        }
        int connectionTimeoutInSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(this.getConnectionTimeoutInMs());
        if (this.getLoginTimeoutInSeconds() > connectionTimeoutInSeconds) {
            logger.info("Setting loginTimeoutInSeconds to {}", (Object)connectionTimeoutInSeconds);
            this.setLoginTimeoutInSeconds(connectionTimeoutInSeconds);
        }
        if (this.getLogConnectionLongerThanMs() > this.getConnectionTimeoutInMs()) {
            logger.info("Setting logConnectionLongerThanMs to {}", (Object)this.getConnectionTimeoutInMs());
            this.setLogConnectionLongerThanMs(this.getConnectionTimeoutInMs());
        }
        if (this.isLogTakenConnectionsOnTimeout() && !this.isPoolEnableConnectionTracking()) {
            logger.info("Setting poolEnableConnectionTracking to true");
            this.setPoolEnableConnectionTracking(true);
        }
        if (this.getStatementCacheMaxSize() > 2000) {
            logger.info("Setting statementCacheMaxSize to {}", (Object)2000);
            this.setStatementCacheMaxSize(2000);
        }
        if (this.getDefaultTransactionIsolation() != null) {
            String defaultTransactionIsolation;
            switch (defaultTransactionIsolation = this.getDefaultTransactionIsolation().toUpperCase()) {
                case "NONE": {
                    this.setDefaultTransactionIsolationIntValue(0);
                    break;
                }
                case "READ_COMMITTED": {
                    this.setDefaultTransactionIsolationIntValue(2);
                    break;
                }
                case "REPEATABLE_READ": {
                    this.setDefaultTransactionIsolationIntValue(4);
                    break;
                }
                case "READ_UNCOMMITTED": {
                    this.setDefaultTransactionIsolationIntValue(1);
                    break;
                }
                case "SERIALIZABLE": {
                    this.setDefaultTransactionIsolationIntValue(8);
                    break;
                }
                default: {
                    logger.warn("Unknown defaultTransactionIsolation {}. Will use the driver's default.", (Object)this.getDefaultTransactionIsolation());
                }
            }
        }
    }

    private void initJdbcDriver() throws ViburDBCPException {
        if (this.getDriver() == null) {
            try {
                if (this.getDriverClassName() != null) {
                    this.setDriver((Driver)Class.forName(this.getDriverClassName()).newInstance());
                } else {
                    this.setDriver(DriverManager.getDriver(this.getJdbcUrl()));
                }
            }
            catch (ClassCastException | ReflectiveOperationException | SQLException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    private void initDefaultHooks() {
        this.getConnHooks().addOnInit(new DefaultHook.InitConnection(this));
        this.getConnHooks().addOnGet(new DefaultHook.GetConnectionTiming(this));
        this.getConnHooks().addOnClose(new DefaultHook.CloseConnection(this));
        this.getConnHooks().addOnTimeout(new DefaultHook.GetConnectionTimeout(this));
        this.getInvocationHooks().addOnStatementExecution(new DefaultHook.QueryTiming(this));
        this.getInvocationHooks().addOnResultSetRetrieval(new DefaultHook.ResultSetSize(this));
    }

    private void initPoolReducer() throws ViburDBCPException {
        ThreadedPoolReducer poolReducer = this.getPoolReducer();
        if (this.getReducerTimeIntervalInSeconds() > 0 && poolReducer == null) {
            try {
                poolReducer = (ThreadedPoolReducer)Class.forName(this.getPoolReducerClass()).getConstructor(ViburConfig.class).newInstance(this);
                this.setPoolReducer(poolReducer);
                poolReducer.start();
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    private void initStatementCache() {
        int statementCacheMaxSize = this.getStatementCacheMaxSize();
        if (statementCacheMaxSize > 0 && this.getStatementCache() == null) {
            this.setStatementCache(new ClhmStatementCache(statementCacheMaxSize));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        ViburDataSource.State state = this.validatePoolState(this.isAllowConnectionAfterTermination());
        if (state == ViburDataSource.State.WORKING) {
            try {
                return this.poolOperations.getProxyConnection(this.getConnectionTimeoutInMs());
            }
            catch (SQLException e) {
                if (!"VI001".equals(e.getSQLState()) || !this.isAllowConnectionAfterTermination()) {
                    throw e;
                }
                logger.info("The pool was closed while retrieving a Connection.");
            }
        }
        assert (this.getState() == ViburDataSource.State.TERMINATED);
        logger.info("Calling getConnection() after the pool was closed; will create and return a non-pooled Connection.");
        return this.getNonPooledConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.defaultCredentials(username, password)) {
            return this.getConnection();
        }
        this.validatePoolState(this.isAllowConnectionAfterTermination());
        logger.warn("Calling getConnection() with different than the default credentials; will create and return a non-pooled Connection.");
        return this.getNonPooledConnection(username, password);
    }

    @Override
    public Connection getNonPooledConnection() throws SQLException {
        return this.getNonPooledConnection(this.getUsername(), this.getPassword());
    }

    @Override
    public Connection getNonPooledConnection(String username, String password) throws SQLException {
        this.validatePoolState(true);
        try {
            Connector connector = Connector.Builder.buildConnector(this, username, password);
            Connection rawConnection = this.getConnectionFactory().create(connector).rawConnection();
            logger.debug("Taking non-pooled rawConnection {}", (Object)rawConnection);
            return rawConnection;
        }
        catch (ViburDBCPException e) {
            throw e.unwrapSQLException();
        }
    }

    @Override
    public void severConnection(Connection connection) throws SQLException {
        InvocationHandler ih;
        if (Proxy.isProxyClass(connection.getClass()) && (ih = Proxy.getInvocationHandler(connection)) instanceof ConnectionInvalidator) {
            ((ConnectionInvalidator)((Object)ih)).invalidate();
            return;
        }
        connection.close();
    }

    private ViburDataSource.State validatePoolState(boolean allowConnectionAfterTermination) throws SQLException {
        ViburDataSource.State state = this.getState();
        switch (state) {
            case NEW: {
                throw new SQLException(String.format("Pool %s, %s", new Object[]{this.getName(), state}), "VI000");
            }
            case WORKING: {
                return state;
            }
            case TERMINATED: {
                if (!allowConnectionAfterTermination) {
                    throw new SQLException(String.format("Pool %s, %s", new Object[]{ViburUtils.getPoolName(this), state}), "VI001");
                }
                return state;
            }
        }
        throw new AssertionError((Object)state);
    }

    private boolean defaultCredentials(String username, String password) {
        if (this.getUsername() != null ? !this.getUsername().equals(username) : username != null) {
            return false;
        }
        return this.getPassword() != null ? this.getPassword().equals(password) : password == null;
    }

    @Override
    public String getTakenConnectionsStackTraces() {
        if (!this.isPoolEnableConnectionTracking() || this.getState() != ViburDataSource.State.WORKING) {
            return "poolEnableConnectionTracking is disabled or the pool is not in working state";
        }
        return this.getTakenConnectionsFormatter().formatTakenConnections(this.getTakenConnections());
    }

    @Override
    public TakenConnection[] getTakenConnections() {
        if (!this.isPoolEnableConnectionTracking() || this.getState() != ViburDataSource.State.WORKING) {
            return ViburListener.NO_TAKEN_CONNECTIONS;
        }
        return ((ViburListener)this.getPool().listener()).getTakenConnections();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.setLoginTimeoutInSeconds(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return this.getLoginTimeoutInSeconds();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.getExternalDataSource();
        }
        throw new SQLException("Not a wrapper for " + iface, "VI006");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return this.isAllowUnwrapping() && iface.isInstance(this.getExternalDataSource());
    }

    public static interface ConnectionInvalidator {
        public void invalidate();
    }
}

