/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import twitter4j.HttpParameter;
import twitter4j.StringUtil;

public final class FilterQuery
implements Serializable {
    private static final long serialVersionUID = -142808200594318258L;
    private int count;
    private long[] follow;
    private String[] track;
    private double[][] locations;
    private String[] language;
    private String filterLevel;

    public FilterQuery() {
        this.count = 0;
        this.follow = null;
        this.track = null;
        this.locations = null;
        this.language = null;
        this.filterLevel = null;
    }

    public FilterQuery(long[] follow) {
        this();
        this.count = 0;
        this.follow = follow;
    }

    public FilterQuery(int count, long[] follow) {
        this();
        this.count = count;
        this.follow = follow;
    }

    public FilterQuery(int count, long[] follow, String[] track) {
        this();
        this.count = count;
        this.follow = follow;
        this.track = track;
    }

    public FilterQuery(int count, long[] follow, String[] track, double[][] locations) {
        this.count = count;
        this.follow = follow;
        this.track = track;
        this.locations = locations;
    }

    public FilterQuery(int count, long[] follow, String[] track, double[][] locations, String[] language) {
        this.count = count;
        this.follow = follow;
        this.track = track;
        this.locations = locations;
        this.language = language;
    }

    public FilterQuery count(int count) {
        this.count = count;
        return this;
    }

    public FilterQuery follow(long[] follow) {
        this.follow = follow;
        return this;
    }

    public FilterQuery track(String[] track) {
        this.track = track;
        return this;
    }

    public FilterQuery locations(double[][] locations) {
        this.locations = locations;
        return this;
    }

    public FilterQuery language(String[] language) {
        this.language = language;
        return this;
    }

    public FilterQuery filterLevel(String filterLevel) {
        this.filterLevel = filterLevel;
        return this;
    }

    HttpParameter[] asHttpParameterArray(HttpParameter stallWarningsParam) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("count", this.count));
        if (this.follow != null && this.follow.length > 0) {
            params.add(new HttpParameter("follow", StringUtil.join((long[])this.follow)));
        }
        if (this.track != null && this.track.length > 0) {
            params.add(new HttpParameter("track", StringUtil.join((String[])this.track)));
        }
        if (this.locations != null && this.locations.length > 0) {
            params.add(new HttpParameter("locations", this.toLocationsString(this.locations)));
        }
        if (this.language != null && this.language.length > 0) {
            params.add(new HttpParameter("language", StringUtil.join((String[])this.language)));
        }
        if (this.filterLevel != null && this.language.length > 0) {
            params.add(new HttpParameter("filter_level", this.filterLevel));
        }
        params.add(stallWarningsParam);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private String toLocationsString(double[][] keywords) {
        StringBuilder buf = new StringBuilder(20 * keywords.length * 2);
        for (double[] keyword : keywords) {
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keyword[0]);
            buf.append(",");
            buf.append(keyword[1]);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterQuery that = (FilterQuery)o;
        if (this.count != that.count) {
            return false;
        }
        if (!Arrays.equals(this.follow, that.follow)) {
            return false;
        }
        if (!Arrays.equals(this.track, that.track)) {
            return false;
        }
        if (!Arrays.equals(this.language, that.language)) {
            return false;
        }
        return this.filterLevel != null ? this.filterLevel.equals(that.filterLevel) : that.filterLevel == null;
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + (this.follow != null ? Arrays.hashCode(this.follow) : 0);
        result = 31 * result + (this.track != null ? Arrays.hashCode(this.track) : 0);
        result = 31 * result + (this.language != null ? Arrays.hashCode(this.language) : 0);
        result = 31 * result + (this.filterLevel != null ? this.filterLevel.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FilterQuery{count=" + this.count + ", follow=" + Arrays.toString(this.follow) + ", track=" + (this.track == null ? null : Arrays.asList(this.track)) + ", locations=" + (this.locations == null ? null : Arrays.asList(this.locations)) + ", language=" + (this.language == null ? null : Arrays.asList(this.language)) + ", filter_level=" + this.filterLevel + '}';
    }
}

