/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import twitter4j.Configuration;
import twitter4j.Logger;

final class PropertyConfiguration {
    private static final Logger logger = Logger.getLogger();
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String HTTP_PRETTY_DEBUG = "http.prettyDebug";
    private static final String HTTP_GZIP = "http.gzip";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    private static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    private static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    private static final String HTTP_STREAMING_READ_TIMEOUT = "http.streamingReadTimeout";
    private static final String HTTP_RETRY_COUNT = "http.retryCount";
    private static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    private static final String OAUTH_CONSUMER_KEY = "oauth.consumerKey";
    private static final String OAUTH_CONSUMER_SECRET = "oauth.consumerSecret";
    private static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    private static final String OAUTH_ACCESS_TOKEN_SECRET = "oauth.accessTokenSecret";
    private static final String OAUTH2_TOKEN_TYPE = "oauth2.tokenType";
    private static final String OAUTH2_ACCESS_TOKEN = "oauth2.accessToken";
    private static final String OAUTH2_SCOPE = "oauth2.scope";
    private static final String OAUTH_REQUEST_TOKEN_URL = "oauth.requestTokenURL";
    private static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    private static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    private static final String OAUTH_AUTHENTICATION_URL = "oauth.authenticationURL";
    private static final String OAUTH2_TOKEN_URL = "oauth2.tokenURL";
    private static final String OAUTH2_INVALIDATE_TOKEN_URL = "oauth2.invalidateTokenURL";
    private static final String REST_BASE_URL = "restBaseURL";
    private static final String STREAM_BASE_URL = "streamBaseURL";
    private static final String STREAM_THREAD_NAME = "streamThreadName";
    private static final String CONTRIBUTING_TO = "contributingTo";
    private static final String INCLUDE_ENTITIES = "includeEntities";
    private static final String INCLUDE_EXT_ALT_TEXT = "includeExtAltText";
    private static final String TWEET_MODE_EXTENDED = "tweetModeExtended";
    private static final String JSON_STORE_ENABLED = "jsonStoreEnabled";
    private static final String MBEAN_ENABLED = "mbeanEnabled";
    private static final String STREAM_STALL_WARNINGS_ENABLED = "stream.enableStallWarnings";
    private static final String APPLICATION_ONLY_AUTH_ENABLED = "enableApplicationOnlyAuth";

    PropertyConfiguration() {
    }

    static void load(Configuration conf, Properties props) {
        PropertyConfiguration.setFieldsWithPrefix(conf, props);
    }

    static void loadDefaultProperties(Configuration conf) {
        Properties props = (Properties)System.getProperties().clone();
        try {
            try {
                Map<String, String> envMap = System.getenv();
                for (String key : envMap.keySet()) {
                    props.setProperty(key, envMap.get(key));
                }
            }
            catch (SecurityException envMap) {
                // empty catch block
            }
            PropertyConfiguration.normalize(props);
        }
        catch (SecurityException ignore) {
            props = new Properties();
        }
        String TWITTER4J_PROPERTIES = "twitter4j.properties";
        PropertyConfiguration.loadProperties(props, "." + File.separatorChar + "twitter4j.properties");
        PropertyConfiguration.loadProperties(props, Configuration.class.getResourceAsStream("/twitter4j.properties"));
        PropertyConfiguration.loadProperties(props, Configuration.class.getResourceAsStream("/WEB-INF/twitter4j.properties"));
        try {
            PropertyConfiguration.loadProperties(props, new FileInputStream("WEB-INF/twitter4j.properties"));
        }
        catch (FileNotFoundException | SecurityException exception) {
            // empty catch block
        }
        PropertyConfiguration.setFieldsWithPrefix(conf, props);
    }

    private static boolean notNull(Properties props, String name) {
        return props.getProperty(name) != null;
    }

    private static void loadProperties(Properties props, String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            try {
                props.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            }
            catch (IOException ioe) {
                logger.warn("failed to load properties:" + file.getAbsolutePath(), ioe);
            }
            PropertyConfiguration.normalize(props);
        }
    }

    private static void loadProperties(Properties props, InputStream is) {
        try {
            props.load(is);
            PropertyConfiguration.normalize(props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void normalize(Properties props) {
        ArrayList<String> toBeNormalized = new ArrayList<String>(10);
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            if (!keyStr.contains("twitter4j.")) continue;
            toBeNormalized.add(keyStr);
        }
        for (String keyStr : toBeNormalized) {
            String property = props.getProperty(keyStr);
            int index = keyStr.indexOf("twitter4j.");
            String newKey = keyStr.substring(0, index) + keyStr.substring(index + 10);
            props.setProperty(newKey, property);
        }
    }

    private static void setFieldsWithPrefix(Configuration conf, Properties props) {
        if (PropertyConfiguration.notNull(props, USER)) {
            conf.user = PropertyConfiguration.getString(props, USER);
        }
        if (PropertyConfiguration.notNull(props, PASSWORD)) {
            conf.password = PropertyConfiguration.getString(props, PASSWORD);
        }
        if (PropertyConfiguration.notNull(props, HTTP_PRETTY_DEBUG)) {
            conf.prettyDebugEnabled(PropertyConfiguration.getBoolean(props, HTTP_PRETTY_DEBUG));
        }
        if (PropertyConfiguration.notNull(props, HTTP_GZIP)) {
            conf.gzipEnabled(PropertyConfiguration.getBoolean(props, HTTP_GZIP));
        }
        if (PropertyConfiguration.notNull(props, "http.proxyHost")) {
            conf.httpProxyHost = PropertyConfiguration.getString(props, "http.proxyHost");
        } else if (PropertyConfiguration.notNull(props, "http.proxyHost")) {
            conf.httpProxyHost = PropertyConfiguration.getString(props, "http.proxyHost");
        }
        if (PropertyConfiguration.notNull(props, HTTP_PROXY_USER)) {
            conf.httpProxyUser = PropertyConfiguration.getString(props, HTTP_PROXY_USER);
        }
        if (PropertyConfiguration.notNull(props, HTTP_PROXY_PASSWORD)) {
            conf.httpProxyPassword = PropertyConfiguration.getString(props, HTTP_PROXY_PASSWORD);
        }
        if (PropertyConfiguration.notNull(props, "http.proxyPort")) {
            conf.httpProxyPort(PropertyConfiguration.getIntProperty(props, "http.proxyPort"));
        } else if (PropertyConfiguration.notNull(props, "http.proxyPort")) {
            conf.httpProxyPort(PropertyConfiguration.getIntProperty(props, "http.proxyPort"));
        }
        if (PropertyConfiguration.notNull(props, HTTP_CONNECTION_TIMEOUT)) {
            conf.httpConnectionTimeout(PropertyConfiguration.getIntProperty(props, HTTP_CONNECTION_TIMEOUT));
        }
        if (PropertyConfiguration.notNull(props, HTTP_READ_TIMEOUT)) {
            conf.httpReadTimeout(PropertyConfiguration.getIntProperty(props, HTTP_READ_TIMEOUT));
        }
        if (PropertyConfiguration.notNull(props, HTTP_STREAMING_READ_TIMEOUT)) {
            conf.httpStreamingReadTimeout(PropertyConfiguration.getIntProperty(props, HTTP_STREAMING_READ_TIMEOUT));
        }
        if (PropertyConfiguration.notNull(props, HTTP_RETRY_COUNT)) {
            conf.httpRetryCount(PropertyConfiguration.getIntProperty(props, HTTP_RETRY_COUNT));
        }
        if (PropertyConfiguration.notNull(props, HTTP_RETRY_INTERVAL_SECS)) {
            conf.httpRetryIntervalSeconds(PropertyConfiguration.getIntProperty(props, HTTP_RETRY_INTERVAL_SECS));
        }
        if (PropertyConfiguration.notNull(props, OAUTH_CONSUMER_KEY)) {
            conf.oAuthConsumerKey = PropertyConfiguration.getString(props, OAUTH_CONSUMER_KEY);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_CONSUMER_SECRET)) {
            conf.oAuthConsumerSecret = PropertyConfiguration.getString(props, OAUTH_CONSUMER_SECRET);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_ACCESS_TOKEN)) {
            conf.oAuthAccessToken = PropertyConfiguration.getString(props, OAUTH_ACCESS_TOKEN);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_ACCESS_TOKEN_SECRET)) {
            conf.oAuthAccessTokenSecret = PropertyConfiguration.getString(props, OAUTH_ACCESS_TOKEN_SECRET);
        }
        if (PropertyConfiguration.notNull(props, OAUTH2_TOKEN_TYPE)) {
            conf.oAuth2TokenType = PropertyConfiguration.getString(props, OAUTH2_TOKEN_TYPE);
        }
        if (PropertyConfiguration.notNull(props, OAUTH2_ACCESS_TOKEN)) {
            conf.oAuth2AccessToken = PropertyConfiguration.getString(props, OAUTH2_ACCESS_TOKEN);
        }
        if (PropertyConfiguration.notNull(props, OAUTH2_SCOPE)) {
            conf.oAuth2Scope = PropertyConfiguration.getString(props, OAUTH2_SCOPE);
        }
        if (PropertyConfiguration.notNull(props, STREAM_THREAD_NAME)) {
            conf.streamThreadName = PropertyConfiguration.getString(props, STREAM_THREAD_NAME);
        }
        if (PropertyConfiguration.notNull(props, CONTRIBUTING_TO)) {
            conf.contributingTo = PropertyConfiguration.getLongProperty(props, CONTRIBUTING_TO);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_REQUEST_TOKEN_URL)) {
            conf.oAuthRequestTokenURL = PropertyConfiguration.getString(props, OAUTH_REQUEST_TOKEN_URL);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_AUTHORIZATION_URL)) {
            conf.oAuthAuthorizationURL = PropertyConfiguration.getString(props, OAUTH_AUTHORIZATION_URL);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_ACCESS_TOKEN_URL)) {
            conf.oAuthAccessTokenURL = PropertyConfiguration.getString(props, OAUTH_ACCESS_TOKEN_URL);
        }
        if (PropertyConfiguration.notNull(props, OAUTH_AUTHENTICATION_URL)) {
            conf.oAuthAuthenticationURL = PropertyConfiguration.getString(props, OAUTH_AUTHENTICATION_URL);
        }
        if (PropertyConfiguration.notNull(props, OAUTH2_TOKEN_URL)) {
            conf.oAuth2TokenURL = PropertyConfiguration.getString(props, OAUTH2_TOKEN_URL);
        }
        if (PropertyConfiguration.notNull(props, OAUTH2_INVALIDATE_TOKEN_URL)) {
            conf.oAuth2InvalidateTokenURL = PropertyConfiguration.getString(props, OAUTH2_INVALIDATE_TOKEN_URL);
        }
        if (PropertyConfiguration.notNull(props, REST_BASE_URL)) {
            conf.restBaseURL = PropertyConfiguration.getString(props, REST_BASE_URL);
        }
        if (PropertyConfiguration.notNull(props, STREAM_BASE_URL)) {
            conf.streamBaseURL = PropertyConfiguration.getString(props, STREAM_BASE_URL);
        }
        if (PropertyConfiguration.notNull(props, INCLUDE_ENTITIES)) {
            conf.includeEntitiesEnabled = PropertyConfiguration.getBoolean(props, INCLUDE_ENTITIES);
        }
        if (PropertyConfiguration.notNull(props, INCLUDE_EXT_ALT_TEXT)) {
            conf.includeExtAltTextEnabled = PropertyConfiguration.getBoolean(props, INCLUDE_EXT_ALT_TEXT);
        }
        if (PropertyConfiguration.notNull(props, TWEET_MODE_EXTENDED)) {
            conf.tweetModeExtended = PropertyConfiguration.getBoolean(props, TWEET_MODE_EXTENDED);
        }
        if (PropertyConfiguration.notNull(props, JSON_STORE_ENABLED)) {
            conf.jsonStoreEnabled = PropertyConfiguration.getBoolean(props, JSON_STORE_ENABLED);
        }
        if (PropertyConfiguration.notNull(props, MBEAN_ENABLED)) {
            conf.mbeanEnabled = PropertyConfiguration.getBoolean(props, MBEAN_ENABLED);
        }
        if (PropertyConfiguration.notNull(props, STREAM_STALL_WARNINGS_ENABLED)) {
            conf.stallWarningsEnabled = PropertyConfiguration.getBoolean(props, STREAM_STALL_WARNINGS_ENABLED);
        }
        if (PropertyConfiguration.notNull(props, APPLICATION_ONLY_AUTH_ENABLED)) {
            conf.applicationOnlyAuthEnabled = PropertyConfiguration.getBoolean(props, APPLICATION_ONLY_AUTH_ENABLED);
        }
    }

    private static boolean getBoolean(Properties props, String name) {
        String value = props.getProperty(name);
        return Boolean.parseBoolean(value);
    }

    private static int getIntProperty(Properties props, String name) {
        String value = props.getProperty(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static long getLongProperty(Properties props, String name) {
        String value = props.getProperty(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    private static String getString(Properties props, String name) {
        return props.getProperty(name);
    }
}

