/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import twitter4j.HTMLEntity;
import twitter4j.HttpResponse;
import twitter4j.JSONObject;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;

final class ParseUtil {
    static DateTimeFormatter formatterYYYY = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    static DateTimeFormatter formatterEEE = DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    static DateTimeFormatter formatterEEEYYYY = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss Z yyyy", Locale.US);
    private static final Map<String, DateTimeFormatter> formatterMap = new ConcurrentHashMap<String, DateTimeFormatter>();

    private ParseUtil() {
        throw new AssertionError();
    }

    static String getUnescapedString(String str, JSONObject json) {
        return HTMLEntity.unescape(ParseUtil.getRawString(str, json));
    }

    public static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = ParseUtil.getRawString(name, json);
        if (returnValue != null) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return returnValue;
    }

    public static LocalDateTime parseTrendsDate(String asOfStr) throws TwitterException {
        LocalDateTime parsed;
        switch (asOfStr.length()) {
            case 10: {
                parsed = Instant.ofEpochMilli(Long.parseLong(asOfStr) * 1000L).atZone(ZoneId.systemDefault()).toLocalDateTime();
                break;
            }
            case 20: {
                parsed = ParseUtil.getDate(asOfStr, formatterYYYY);
                break;
            }
            default: {
                parsed = ParseUtil.getDate(asOfStr, formatterEEE);
            }
        }
        return parsed;
    }

    public static LocalDateTime getDate(String name, JSONObject json) throws TwitterException {
        return ParseUtil.getDate(name, json, formatterEEEYYYY);
    }

    public static LocalDateTime getDate(String name, JSONObject json, String format) throws TwitterException {
        return ParseUtil.getDate(name, json, ParseUtil.getFormat(format));
    }

    private static DateTimeFormatter getFormat(String format) {
        return formatterMap.computeIfAbsent(format, pattern -> DateTimeFormatter.ofPattern(pattern, Locale.US));
    }

    public static LocalDateTime getDate(String name, JSONObject json, DateTimeFormatter format) throws TwitterException {
        String dateStr = ParseUtil.getUnescapedString(name, json);
        if ("null".equals(dateStr) || null == dateStr) {
            return null;
        }
        return ParseUtil.getDate(dateStr, format);
    }

    public static LocalDateTime getDate(String dateString, String format) throws TwitterException {
        return ParseUtil.getDate(dateString, ParseUtil.getFormat(format));
    }

    public static LocalDateTime getDate(String dateString, DateTimeFormatter format) throws TwitterException {
        try {
            return LocalDateTime.from(format.parse(dateString));
        }
        catch (DateTimeParseException pe) {
            throw new TwitterException("Unexpected date format(" + dateString + ") returned from twitter.com", pe);
        }
    }

    public static int getInt(String name, JSONObject json) {
        return ParseUtil.getInt(ParseUtil.getRawString(name, json));
    }

    public static int getInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLong(String name, JSONObject json) {
        return ParseUtil.getLong(ParseUtil.getRawString(name, json));
    }

    public static long getLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        if (str.endsWith("+")) {
            str = str.substring(0, str.length() - 1);
            return Long.parseLong(str) + 1L;
        }
        return Long.parseLong(str);
    }

    public static double getDouble(String name, JSONObject json) {
        String str2 = ParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.parseDouble(str2);
    }

    public static boolean getBoolean(String name, JSONObject json) {
        String str = ParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return false;
        }
        return Boolean.parseBoolean(str);
    }

    public static TwitterResponse.AccessLevel toAccessLevel(HttpResponse res) {
        TwitterResponse.AccessLevel accessLevel;
        if (null == res) {
            return TwitterResponse.AccessLevel.NONE;
        }
        String xAccessLevel = res.getResponseHeader("X-Access-Level");
        if (null == xAccessLevel) {
            accessLevel = TwitterResponse.AccessLevel.NONE;
        } else {
            switch (xAccessLevel.length()) {
                case 4: {
                    accessLevel = TwitterResponse.AccessLevel.READ;
                    break;
                }
                case 10: {
                    accessLevel = TwitterResponse.AccessLevel.READ_WRITE;
                    break;
                }
                case 25: 
                case 26: {
                    accessLevel = TwitterResponse.AccessLevel.READ_WRITE_DIRECTMESSAGES;
                    break;
                }
                default: {
                    accessLevel = TwitterResponse.AccessLevel.NONE;
                }
            }
        }
        return accessLevel;
    }
}

