/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import twitter4j.HttpParameter;
import twitter4j.StringUtil;

public final class OEmbedRequest
implements Serializable {
    private static final long serialVersionUID = 7454130135274547901L;
    private final long statusId;
    private final String url;
    private int maxWidth;
    private boolean hideMedia = true;
    private boolean hideThread = true;
    private boolean omitScript = false;
    private Align align = Align.NONE;
    private String[] related = new String[0];
    private String lang;
    private WidgetType widgetType = WidgetType.NONE;
    private boolean hideTweet = false;

    public OEmbedRequest(long statusId, String url) {
        this.statusId = statusId;
        this.url = url;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public OEmbedRequest MaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public void setHideMedia(boolean hideMedia) {
        this.hideMedia = hideMedia;
    }

    public OEmbedRequest HideMedia(boolean hideMedia) {
        this.hideMedia = hideMedia;
        return this;
    }

    public void setHideThread(boolean hideThread) {
        this.hideThread = hideThread;
    }

    public OEmbedRequest HideThread(boolean hideThread) {
        this.hideThread = hideThread;
        return this;
    }

    public void setOmitScript(boolean omitScript) {
        this.omitScript = omitScript;
    }

    public OEmbedRequest omitScript(boolean omitScript) {
        this.omitScript = omitScript;
        return this;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public OEmbedRequest align(Align align) {
        this.align = align;
        return this;
    }

    public void setRelated(String[] related) {
        this.related = related;
    }

    public OEmbedRequest related(String[] related) {
        this.related = related;
        return this;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public OEmbedRequest lang(String lang) {
        this.lang = lang;
        return this;
    }

    public void setWidgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
    }

    public OEmbedRequest widgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
        return this;
    }

    public void setHideTweet(boolean hideTweet) {
        this.hideTweet = hideTweet;
    }

    public OEmbedRequest hideTweet(boolean hideTweet) {
        this.hideTweet = hideTweet;
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(12);
        this.appendParameter("id", this.statusId, params);
        this.appendParameter("url", this.url, params);
        this.appendParameter("maxwidth", this.maxWidth, params);
        params.add(new HttpParameter("hide_media", this.hideMedia));
        params.add(new HttpParameter("hide_thread", this.hideThread));
        params.add(new HttpParameter("omit_script", this.omitScript));
        params.add(new HttpParameter("align", this.align.name().toLowerCase()));
        if (this.related.length > 0) {
            this.appendParameter("related", StringUtil.join(this.related), params);
        }
        this.appendParameter("lang", this.lang, params);
        if (this.widgetType != WidgetType.NONE) {
            params.add(new HttpParameter("widget_type", this.widgetType.name().toLowerCase()));
            params.add(new HttpParameter("hide_tweet", this.hideTweet));
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        if (0L <= value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OEmbedRequest that = (OEmbedRequest)o;
        if (this.hideMedia != that.hideMedia) {
            return false;
        }
        if (this.hideThread != that.hideThread) {
            return false;
        }
        if (this.maxWidth != that.maxWidth) {
            return false;
        }
        if (this.omitScript != that.omitScript) {
            return false;
        }
        if (this.statusId != that.statusId) {
            return false;
        }
        if (this.align != that.align) {
            return false;
        }
        if (!Objects.equals(this.lang, that.lang)) {
            return false;
        }
        if (!Arrays.equals(this.related, that.related)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (this.widgetType != that.widgetType) {
            return false;
        }
        return this.hideTweet == that.hideTweet;
    }

    public int hashCode() {
        int result = (int)(this.statusId ^ this.statusId >>> 32);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + this.maxWidth;
        result = 31 * result + (this.hideMedia ? 1 : 0);
        result = 31 * result + (this.hideThread ? 1 : 0);
        result = 31 * result + (this.omitScript ? 1 : 0);
        result = 31 * result + (this.align != null ? this.align.hashCode() : 0);
        result = 31 * result + (this.related != null ? Arrays.hashCode(this.related) : 0);
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + (this.widgetType != null ? this.widgetType.hashCode() : 0);
        result = 31 * result + (this.hideTweet ? 1 : 0);
        return result;
    }

    public String toString() {
        return "OEmbedRequest{statusId=" + this.statusId + ", url='" + this.url + '\'' + ", maxWidth=" + this.maxWidth + ", hideMedia=" + this.hideMedia + ", hideThread=" + this.hideThread + ", omitScript=" + this.omitScript + ", align=" + (Object)((Object)this.align) + ", related=" + (this.related == null ? null : Arrays.asList(this.related)) + ", lang='" + this.lang + '\'' + ", widgetType=" + (Object)((Object)this.widgetType) + ", hideTweet=" + this.hideTweet + '}';
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT,
        NONE;

    }

    public static enum WidgetType {
        VIDEO,
        NONE;

    }
}

