/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import twitter4j.GeoLocation;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONImplFactory;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.Place;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlaceJSONImpl
extends TwitterResponseImpl
implements Place,
Serializable {
    private static final long serialVersionUID = -6368276880878829754L;
    private String name;
    private String streetAddress;
    private String countryCode;
    private String id;
    private String country;
    private String placeType;
    private String url;
    private String fullName;
    private String boundingBoxType;
    private GeoLocation[][] boundingBoxCoordinates;
    private String geometryType;
    private GeoLocation[][] geometryCoordinates;
    private Place[] containedWithIn;

    PlaceJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    PlaceJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    PlaceJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray array;
            this.name = ParseUtil.getUnescapedString("name", json);
            this.streetAddress = ParseUtil.getUnescapedString("street_address", json);
            this.countryCode = ParseUtil.getRawString("country_code", json);
            this.id = ParseUtil.getRawString("id", json);
            this.country = ParseUtil.getRawString("country", json);
            this.placeType = !json.isNull("place_type") ? ParseUtil.getRawString("place_type", json) : ParseUtil.getRawString("type", json);
            this.url = ParseUtil.getRawString("url", json);
            this.fullName = ParseUtil.getRawString("full_name", json);
            if (!json.isNull("bounding_box")) {
                JSONObject boundingBoxJSON = json.getJSONObject("bounding_box");
                this.boundingBoxType = ParseUtil.getRawString("type", boundingBoxJSON);
                array = boundingBoxJSON.getJSONArray("coordinates");
                this.boundingBoxCoordinates = JSONImplFactory.coordinatesAsGeoLocationArray(array);
            } else {
                this.boundingBoxType = null;
                this.boundingBoxCoordinates = null;
            }
            if (!json.isNull("geometry")) {
                JSONObject geometryJSON = json.getJSONObject("geometry");
                this.geometryType = ParseUtil.getRawString("type", geometryJSON);
                array = geometryJSON.getJSONArray("coordinates");
                if (this.geometryType.equals("Point")) {
                    this.geometryCoordinates = new GeoLocation[1][1];
                    this.geometryCoordinates[0][0] = new GeoLocation(array.getDouble(1), array.getDouble(0));
                } else if (this.geometryType.equals("Polygon")) {
                    this.geometryCoordinates = JSONImplFactory.coordinatesAsGeoLocationArray(array);
                } else {
                    this.geometryType = null;
                    this.geometryCoordinates = null;
                }
            } else {
                this.geometryType = null;
                this.geometryCoordinates = null;
            }
            if (!json.isNull("contained_within")) {
                JSONArray containedWithInJSON = json.getJSONArray("contained_within");
                this.containedWithIn = new Place[containedWithInJSON.length()];
                for (int i = 0; i < containedWithInJSON.length(); ++i) {
                    this.containedWithIn[i] = new PlaceJSONImpl(containedWithInJSON.getJSONObject(i));
                }
            } else {
                this.containedWithIn = null;
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    @Override
    public int compareTo(Place that) {
        return this.id.compareTo(that.getId());
    }

    static ResponseList<Place> createPlaceList(HttpResponse res, Configuration conf) throws TwitterException {
        JSONObject json = null;
        try {
            json = res.asJSONObject();
            return PlaceJSONImpl.createPlaceList(json.getJSONObject("result").getJSONArray("places"), res, conf);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    static ResponseList<Place> createPlaceList(JSONArray list, HttpResponse res, Configuration conf) throws TwitterException {
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        try {
            int size = list.length();
            ResponseListImpl<Place> places = new ResponseListImpl<Place>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                PlaceJSONImpl place = new PlaceJSONImpl(json);
                places.add(place);
                if (!conf.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(place, json);
            }
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(places, list);
            }
            return places;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getPlaceType() {
        return this.placeType;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getBoundingBoxType() {
        return this.boundingBoxType;
    }

    @Override
    public GeoLocation[][] getBoundingBoxCoordinates() {
        return this.boundingBoxCoordinates;
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    @Override
    public GeoLocation[][] getGeometryCoordinates() {
        return this.geometryCoordinates;
    }

    @Override
    public Place[] getContainedWithIn() {
        return this.containedWithIn;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Place && ((Place)obj).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "PlaceJSONImpl{name='" + this.name + '\'' + ", streetAddress='" + this.streetAddress + '\'' + ", countryCode='" + this.countryCode + '\'' + ", id='" + this.id + '\'' + ", country='" + this.country + '\'' + ", placeType='" + this.placeType + '\'' + ", url='" + this.url + '\'' + ", fullName='" + this.fullName + '\'' + ", boundingBoxType='" + this.boundingBoxType + '\'' + ", boundingBoxCoordinates=" + (this.boundingBoxCoordinates == null ? null : Arrays.asList(this.boundingBoxCoordinates)) + ", geometryType='" + this.geometryType + '\'' + ", geometryCoordinates=" + (this.geometryCoordinates == null ? null : Arrays.asList(this.geometryCoordinates)) + ", containedWithIn=" + (this.containedWithIn == null ? null : Arrays.asList(this.containedWithIn)) + '}';
    }
}

