/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import java.util.Locale;
import org.tinylog.runtime.AndroidRuntime;
import org.tinylog.runtime.LegacyJavaRuntime;
import org.tinylog.runtime.ModernJavaRuntime;
import org.tinylog.runtime.RuntimeDialect;
import org.tinylog.runtime.Timestamp;
import org.tinylog.runtime.TimestampFormatter;

public final class RuntimeProvider {
    private static final int MINIMUM_VERSION_MODERN_JAVA = 9;
    private static final RuntimeDialect dialect = RuntimeProvider.resolveDialect();

    private RuntimeProvider() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = RuntimeProvider.class.getClassLoader();
        }
        return classLoader;
    }

    public static String getDefaultWriter() {
        return dialect.getDefaultWriter();
    }

    public static long getProcessId() {
        return dialect.getProcessId();
    }

    public static String getCallerClassName(int depth) {
        return RuntimeProvider.stripAnonymousPart(dialect.getCallerClassName(depth + 1));
    }

    public static String getCallerClassName(String loggerClassName) {
        return RuntimeProvider.stripAnonymousPart(dialect.getCallerClassName(loggerClassName));
    }

    public static StackTraceElement getCallerStackTraceElement(int depth) {
        return RuntimeProvider.normalizeClassName(dialect.getCallerStackTraceElement(depth + 1));
    }

    public static StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        return RuntimeProvider.normalizeClassName(dialect.getCallerStackTraceElement(loggerClassName));
    }

    public static Timestamp createTimestamp() {
        return dialect.createTimestamp();
    }

    public static TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return dialect.createTimestampFormatter(pattern, locale);
    }

    private static RuntimeDialect resolveDialect() {
        if (RuntimeProvider.getJavaVersion() >= 9) {
            return new ModernJavaRuntime();
        }
        if ("Android Runtime".equalsIgnoreCase(System.getProperty("java.runtime.name"))) {
            return new AndroidRuntime();
        }
        return new LegacyJavaRuntime();
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return -1;
        }
        int index = version.indexOf(46);
        if (index > 0) {
            version = version.substring(0, index);
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static String stripAnonymousPart(String className) {
        int index = className.indexOf("$", 0);
        while (index != -1) {
            if (index >= className.length() - 1) {
                return className.substring(0, index);
            }
            char firstLetter = className.charAt(index + 1);
            if (firstLetter < 'A' || firstLetter > 'Z') {
                return className.substring(0, index);
            }
            index = className.indexOf(36, index + 2);
        }
        return className;
    }

    private static StackTraceElement normalizeClassName(StackTraceElement element) {
        String className = element.getClassName();
        int dollarIndex = className.indexOf("$");
        if (dollarIndex == -1) {
            return element;
        }
        className = RuntimeProvider.stripAnonymousPart(className);
        return new StackTraceElement(className, element.getMethodName(), element.getFileName(), element.getLineNumber());
    }
}

