/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.tinylog.runtime.Timestamp;
import org.tinylog.runtime.TimestampFormatter;

@IgnoreJRERequirement
final class PreciseTimestampFormatter
implements TimestampFormatter {
    private final DateTimeFormatter formatter;
    private final TemporalUnit truncationUnit;
    private Instant lastInstant;
    private String lastFormat;

    PreciseTimestampFormatter(String pattern, Locale locale) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, locale).withZone(ZoneId.systemDefault());
        this.truncationUnit = pattern.contains("n") || pattern.contains("N") || pattern.contains("SSSS") ? null : (pattern.contains("S") ? ChronoUnit.MILLIS : (pattern.contains("s") ? ChronoUnit.SECONDS : ChronoUnit.MINUTES));
    }

    @Override
    public boolean isValid(String timestamp) {
        try {
            this.formatter.parse(timestamp);
            return true;
        }
        catch (DateTimeParseException ex) {
            return false;
        }
    }

    @Override
    public String format(Timestamp timestamp) {
        Instant instant = timestamp.toInstant();
        return this.truncationUnit == null ? this.formatter.format(instant) : this.format(instant.truncatedTo(this.truncationUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(Instant instant) {
        DateTimeFormatter dateTimeFormatter = this.formatter;
        synchronized (dateTimeFormatter) {
            if (!instant.equals(this.lastInstant)) {
                this.lastInstant = instant;
                this.lastFormat = this.formatter.format(instant);
            }
            return this.lastFormat;
        }
    }
}

