/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.ObjectSparseSlice;

public class SparseNdArray<T, U extends NdArray<T>>
extends AbstractSparseNdArray<T, U>
implements org.tensorflow.ndarray.SparseNdArray<T, U> {
    private final Class<T> type;

    protected SparseNdArray(Class<T> type, LongNdArray indices, U values, T defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
        this.type = type;
    }

    SparseNdArray(Class<T> type, LongNdArray indices, U values, DimensionalSpace dimensions) {
        this(type, indices, values, null, dimensions);
    }

    SparseNdArray(Class<T> type, DataBuffer<T> dataBuffer, DimensionalSpace dimensions) {
        this(type, dataBuffer, null, dimensions);
    }

    SparseNdArray(Class<T> type, DataBuffer<T> dataBuffer, T defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.type = type;
        this.write(dataBuffer);
    }

    SparseNdArray(Class<T> type, DimensionalSpace dimensions) {
        this((Class<Object>)type, null, dimensions);
    }

    SparseNdArray(Class<T> type, T defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.type = type;
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, LongNdArray indices, U values, DimensionalSpace dimensions) {
        return new SparseNdArray<T, U>(type, indices, values, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, LongNdArray indices, U values, T defaultValue, DimensionalSpace dimensions) {
        return new SparseNdArray<T, U>(type, indices, values, defaultValue, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, DataBuffer<T> dataBuffer, DimensionalSpace dimensions) {
        return new SparseNdArray<DataBuffer<T>, U>(type, dataBuffer, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, DataBuffer<T> dataBuffer, T defaultValue, DimensionalSpace dimensions) {
        return new SparseNdArray<T, U>(type, dataBuffer, defaultValue, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, DimensionalSpace dimensions) {
        return new SparseNdArray<T, U>(type, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, T defaultValue, DimensionalSpace dimensions) {
        return new SparseNdArray<T, U>(type, defaultValue, dimensions);
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, DataBuffer<T> buffer, Shape shape) {
        return new SparseNdArray<DataBuffer<T>, U>(type, buffer, DimensionalSpace.create(shape));
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, DataBuffer<T> buffer, T defaultValue, Shape shape) {
        return new SparseNdArray<T, U>(type, buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, U src) {
        DataBuffer<T> buffer = DataBuffers.ofObjects(type, src.size());
        src.read(buffer);
        return new SparseNdArray<DataBuffer<T>, U>(type, buffer, DimensionalSpace.create(src.shape()));
    }

    public static <T, U extends NdArray<T>> SparseNdArray<T, U> create(Class<T> type, U src, T defaultValue) {
        DataBuffer<T> buffer = DataBuffers.ofObjects(type, src.size());
        src.read(buffer);
        return new SparseNdArray<T, U>(type, buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public U createDefaultArray() {
        return (U)(this.getDefaultValue() == null ? NdArrays.ofObjects(this.type, Shape.scalar()) : NdArrays.scalarOfObject(this.getDefaultValue()));
    }

    @Override
    public U createValues(Shape shape) {
        return (U)NdArrays.ofObjects(this.type, shape);
    }

    @Override
    public U slice(long position, DimensionalSpace sliceDimensions) {
        return (U)new ObjectSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public NdArray<T> read(DataBuffer<T> dst) {
        Object[] defaults = (Object[])Array.newInstance(this.type, (int)dst.size());
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            Object value = this.getValues().getObject(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public NdArray<T> write(DataBuffer<T> src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<T> values = new ArrayList<T>();
        for (long i = 0L; i < src.size(); ++i) {
            if (Objects.equals(src.getObject(i), this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        Object[] valuesArray = (Object[])Array.newInstance(this.type, values.size());
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOfObjects(valuesArray));
        return this;
    }

    @Override
    public U toDense() {
        DataBuffer<T> dataBuffer = DataBuffers.ofObjects(this.type, this.shape().size());
        this.read(dataBuffer);
        return (U)NdArrays.wrap(this.shape(), dataBuffer);
    }

    public NdArray<T> fromDense(NdArray<T> src) {
        DataBuffer<T> buffer = DataBuffers.ofObjects(this.type, src.size());
        src.read(buffer);
        this.write(buffer);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toString() {
        long numElements = this.getValues() == null ? 0L : this.getValues().size();
        Object defaultVal = this.getDefaultValue();
        Object strDefault = defaultVal == null ? "<null>" : (defaultVal instanceof Number ? defaultVal.toString() : "'" + defaultVal + "'");
        return this.getClass().getSimpleName() + "(type=" + this.type.getSimpleName() + ", defaultValue=" + (String)strDefault + ", numElements=" + numElements + ", shape=" + this.shape() + ")";
    }
}

