/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TakeManySparseFromTensorsMap<T>
extends PrimitiveOp {
    private Output<Long> sparseIndices;
    private Output<T> sparseValues;
    private Output<Long> sparseShape;

    public static <T> TakeManySparseFromTensorsMap<T> create(Scope scope, Operand<Long> sparseHandles, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TakeManySparseFromTensorsMap", scope.makeOpName("TakeManySparseFromTensorsMap"));
        opBuilder.addInput(sparseHandles.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new TakeManySparseFromTensorsMap<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<Long> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<T> sparseValues() {
        return this.sparseValues;
    }

    public Output<Long> sparseShape() {
        return this.sparseShape;
    }

    private TakeManySparseFromTensorsMap(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

