/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Requantize<U>
extends PrimitiveOp {
    private Output<U> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <U, T> Requantize<U> create(Scope scope, Operand<T> input, Operand<Float> inputMin, Operand<Float> inputMax, Operand<Float> requestedOutputMin, Operand<Float> requestedOutputMax, Class<U> outType) {
        OperationBuilder opBuilder = scope.env().opBuilder("Requantize", scope.makeOpName("Requantize"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        opBuilder.addInput(requestedOutputMin.asOutput());
        opBuilder.addInput(requestedOutputMax.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new Requantize<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    public Output<Float> outputMin() {
        return this.outputMin;
    }

    public Output<Float> outputMax() {
        return this.outputMax;
    }

    private Requantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }
}

