/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantize<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantize<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<Integer> numBits, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizeAndDequantizeV3", scope.makeOpName("QuantizeAndDequantize"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        opBuilder.addInput(numBits.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.signedInput != null) {
                    opBuilder.setAttr("signed_input", opts.signedInput);
                }
                if (opts.rangeGiven == null) continue;
                opBuilder.setAttr("range_given", opts.rangeGiven);
            }
        }
        return new QuantizeAndDequantize<T>(opBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean signedInput;
        private Boolean rangeGiven;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        private Options() {
        }
    }
}

