/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedBiasAdd<V>
extends PrimitiveOp {
    private Output<V> output;
    private Output<Float> minOut;
    private Output<Float> maxOut;

    public static <V, T, U> QuantizedBiasAdd<V> create(Scope scope, Operand<T> input, Operand<U> bias, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minBias, Operand<Float> maxBias, Class<V> outType) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedBiasAdd", scope.makeOpName("QuantizedBiasAdd"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minBias.asOutput());
        opBuilder.addInput(maxBias.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new QuantizedBiasAdd<V>(opBuilder.build());
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<Float> minOut() {
        return this.minOut;
    }

    public Output<Float> maxOut() {
        return this.maxOut;
    }

    private QuantizedBiasAdd(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }
}

