/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RandomShuffleQueue
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static RandomShuffleQueue create(Scope scope, List<Class<?>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("RandomShuffleQueueV2", scope.makeOpName("RandomShuffleQueue"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] componentTypesArray = new DataType[componentTypes.size()];
        for (int i = 0; i < componentTypesArray.length; ++i) {
            componentTypesArray[i] = DataType.fromClass(componentTypes.get(i));
        }
        opBuilder.setAttr("component_types", componentTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.shapes != null) {
                    Shape[] shapesArray = new Shape[opts.shapes.size()];
                    for (int i = 0; i < shapesArray.length; ++i) {
                        shapesArray[i] = (Shape)opts.shapes.get(i);
                    }
                    opBuilder.setAttr("shapes", shapesArray);
                }
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.minAfterDequeue != null) {
                    opBuilder.setAttr("min_after_dequeue", opts.minAfterDequeue);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new RandomShuffleQueue(opBuilder.build());
    }

    public static Options shapes(List<Shape> shapes) {
        return new Options().shapes(shapes);
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options minAfterDequeue(Long minAfterDequeue) {
        return new Options().minAfterDequeue(minAfterDequeue);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private RandomShuffleQueue(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Shape> shapes;
        private Long capacity;
        private Long minAfterDequeue;
        private Long seed;
        private Long seed2;
        private String container;
        private String sharedName;

        public Options shapes(List<Shape> shapes) {
            this.shapes = shapes;
            return this;
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options minAfterDequeue(Long minAfterDequeue) {
            this.minAfterDequeue = minAfterDequeue;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

