/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSingleSequenceExample
extends PrimitiveOp {
    private List<Output<Long>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<Long>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<Long>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<Long>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;

    public static ParseSingleSequenceExample create(Scope scope, Operand<String> serialized, Operand<String> featureListDenseMissingAssumedEmpty, Iterable<Operand<String>> contextSparseKeys, Iterable<Operand<String>> contextDenseKeys, Iterable<Operand<String>> featureListSparseKeys, Iterable<Operand<String>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults, Operand<String> debugName, List<Class<?>> contextSparseTypes, List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseSingleSequenceExample", scope.makeOpName("ParseSingleSequenceExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder.addInput(debugName.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] contextSparseTypesArray = new DataType[contextSparseTypes.size()];
        for (int i = 0; i < contextSparseTypesArray.length; ++i) {
            contextSparseTypesArray[i] = DataType.fromClass(contextSparseTypes.get(i));
        }
        opBuilder.setAttr("context_sparse_types", contextSparseTypesArray);
        DataType[] featureListDenseTypesArray = new DataType[featureListDenseTypes.size()];
        for (int i = 0; i < featureListDenseTypesArray.length; ++i) {
            featureListDenseTypesArray[i] = DataType.fromClass(featureListDenseTypes.get(i));
        }
        opBuilder.setAttr("feature_list_dense_types", featureListDenseTypesArray);
        DataType[] featureListSparseTypesArray = new DataType[featureListSparseTypes.size()];
        for (int i = 0; i < featureListSparseTypesArray.length; ++i) {
            featureListSparseTypesArray[i] = DataType.fromClass(featureListSparseTypes.get(i));
        }
        opBuilder.setAttr("feature_list_sparse_types", featureListSparseTypesArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = (Shape)opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = (Shape)opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSingleSequenceExample(opBuilder.build());
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<Long>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<Long>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<Long>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<Long>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    private ParseSingleSequenceExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        outputIdx += featureListDenseValuesLength;
    }

    public static class Options {
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

