/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSequenceExample
extends PrimitiveOp {
    private List<Output<Long>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<Long>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<Long>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<Long>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;
    private List<Output<Long>> featureListDenseLengths;

    public static ParseSequenceExample create(Scope scope, Operand<String> serialized, Operand<String> debugName, Iterable<Operand<?>> contextDenseDefaults, List<String> featureListDenseMissingAssumedEmpty, List<String> contextSparseKeys, List<String> contextDenseKeys, List<String> featureListSparseKeys, List<String> featureListDenseKeys, List<Class<?>> contextSparseTypes, List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseSequenceExample", scope.makeOpName("ParseSequenceExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(debugName.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder = scope.applyControlDependencies(opBuilder);
        String[] featureListDenseMissingAssumedEmptyArray = new String[featureListDenseMissingAssumedEmpty.size()];
        for (int i = 0; i < featureListDenseMissingAssumedEmptyArray.length; ++i) {
            featureListDenseMissingAssumedEmptyArray[i] = featureListDenseMissingAssumedEmpty.get(i);
        }
        opBuilder.setAttr("feature_list_dense_missing_assumed_empty", featureListDenseMissingAssumedEmptyArray);
        String[] contextSparseKeysArray = new String[contextSparseKeys.size()];
        for (int i = 0; i < contextSparseKeysArray.length; ++i) {
            contextSparseKeysArray[i] = contextSparseKeys.get(i);
        }
        opBuilder.setAttr("context_sparse_keys", contextSparseKeysArray);
        String[] contextDenseKeysArray = new String[contextDenseKeys.size()];
        for (int i = 0; i < contextDenseKeysArray.length; ++i) {
            contextDenseKeysArray[i] = contextDenseKeys.get(i);
        }
        opBuilder.setAttr("context_dense_keys", contextDenseKeysArray);
        String[] featureListSparseKeysArray = new String[featureListSparseKeys.size()];
        for (int i = 0; i < featureListSparseKeysArray.length; ++i) {
            featureListSparseKeysArray[i] = featureListSparseKeys.get(i);
        }
        opBuilder.setAttr("feature_list_sparse_keys", featureListSparseKeysArray);
        String[] featureListDenseKeysArray = new String[featureListDenseKeys.size()];
        for (int i = 0; i < featureListDenseKeysArray.length; ++i) {
            featureListDenseKeysArray[i] = featureListDenseKeys.get(i);
        }
        opBuilder.setAttr("feature_list_dense_keys", featureListDenseKeysArray);
        DataType[] contextSparseTypesArray = new DataType[contextSparseTypes.size()];
        for (int i = 0; i < contextSparseTypesArray.length; ++i) {
            contextSparseTypesArray[i] = DataType.fromClass(contextSparseTypes.get(i));
        }
        opBuilder.setAttr("context_sparse_types", contextSparseTypesArray);
        DataType[] featureListDenseTypesArray = new DataType[featureListDenseTypes.size()];
        for (int i = 0; i < featureListDenseTypesArray.length; ++i) {
            featureListDenseTypesArray[i] = DataType.fromClass(featureListDenseTypes.get(i));
        }
        opBuilder.setAttr("feature_list_dense_types", featureListDenseTypesArray);
        DataType[] featureListSparseTypesArray = new DataType[featureListSparseTypes.size()];
        for (int i = 0; i < featureListSparseTypesArray.length; ++i) {
            featureListSparseTypesArray[i] = DataType.fromClass(featureListSparseTypes.get(i));
        }
        opBuilder.setAttr("feature_list_sparse_types", featureListSparseTypesArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.NcontextSparse != null) {
                    opBuilder.setAttr("Ncontext_sparse", opts.NcontextSparse);
                }
                if (opts.NcontextDense != null) {
                    opBuilder.setAttr("Ncontext_dense", opts.NcontextDense);
                }
                if (opts.NfeatureListSparse != null) {
                    opBuilder.setAttr("Nfeature_list_sparse", opts.NfeatureListSparse);
                }
                if (opts.NfeatureListDense != null) {
                    opBuilder.setAttr("Nfeature_list_dense", opts.NfeatureListDense);
                }
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = (Shape)opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = (Shape)opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSequenceExample(opBuilder.build());
    }

    public static Options NcontextSparse(Long NcontextSparse) {
        return new Options().NcontextSparse(NcontextSparse);
    }

    public static Options NcontextDense(Long NcontextDense) {
        return new Options().NcontextDense(NcontextDense);
    }

    public static Options NfeatureListSparse(Long NfeatureListSparse) {
        return new Options().NfeatureListSparse(NfeatureListSparse);
    }

    public static Options NfeatureListDense(Long NfeatureListDense) {
        return new Options().NfeatureListDense(NfeatureListDense);
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<Long>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<Long>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<Long>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<Long>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    public List<Output<Long>> featureListDenseLengths() {
        return this.featureListDenseLengths;
    }

    private ParseSequenceExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        int featureListDenseLengthsLength = operation.outputListLength("feature_list_dense_lengths");
        this.featureListDenseLengths = Arrays.asList(operation.outputList(outputIdx += featureListDenseValuesLength, featureListDenseLengthsLength));
        outputIdx += featureListDenseLengthsLength;
    }

    public static class Options {
        private Long NcontextSparse;
        private Long NcontextDense;
        private Long NfeatureListSparse;
        private Long NfeatureListDense;
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        public Options NcontextSparse(Long NcontextSparse) {
            this.NcontextSparse = NcontextSparse;
            return this;
        }

        public Options NcontextDense(Long NcontextDense) {
            this.NcontextDense = NcontextDense;
            return this;
        }

        public Options NfeatureListSparse(Long NfeatureListSparse) {
            this.NfeatureListSparse = NfeatureListSparse;
            return this;
        }

        public Options NfeatureListDense(Long NfeatureListDense) {
            this.NfeatureListDense = NfeatureListDense;
            return this;
        }

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

