/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BigQueryReader
extends PrimitiveOp
implements Operand<String> {
    private Output<String> readerHandle;

    public static BigQueryReader create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BigQueryReader", scope.makeOpName("BigQueryReader"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("project_id", projectId);
        opBuilder.setAttr("dataset_id", datasetId);
        opBuilder.setAttr("table_id", tableId);
        String[] columnsArray = new String[columns.size()];
        for (int i = 0; i < columnsArray.length; ++i) {
            columnsArray[i] = columns.get(i);
        }
        opBuilder.setAttr("columns", columnsArray);
        opBuilder.setAttr("timestamp_millis", timestampMillis);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.testEndPoint == null) continue;
                opBuilder.setAttr("test_end_point", opts.testEndPoint);
            }
        }
        return new BigQueryReader(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options testEndPoint(String testEndPoint) {
        return new Options().testEndPoint(testEndPoint);
    }

    public Output<String> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<String> asOutput() {
        return this.readerHandle;
    }

    private BigQueryReader(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private String testEndPoint;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options testEndPoint(String testEndPoint) {
            this.testEndPoint = testEndPoint;
            return this;
        }

        private Options() {
        }
    }
}

