/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class PrefetchDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static PrefetchDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> bufferSize, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("PrefetchDataset", scope.makeOpName("PrefetchDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.slackPeriod == null) continue;
                opBuilder.setAttr("slack_period", opts.slackPeriod);
            }
        }
        return new PrefetchDataset(opBuilder.build());
    }

    public static Options slackPeriod(Long slackPeriod) {
        return new Options().slackPeriod(slackPeriod);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private PrefetchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long slackPeriod;

        public Options slackPeriod(Long slackPeriod) {
            this.slackPeriod = slackPeriod;
            return this;
        }

        private Options() {
        }
    }
}

