/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TPUReplicatedOutput<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> outputs;

    public static <T> TPUReplicatedOutput<T> create(Scope scope, Operand<T> input, Long numReplicas) {
        OperationBuilder opBuilder = scope.env().opBuilder("TPUReplicatedOutput", scope.makeOpName("TPUReplicatedOutput"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_replicas", numReplicas);
        return new TPUReplicatedOutput<T>(opBuilder.build());
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    private TPUReplicatedOutput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }
}

