/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class GenerateBigQueryReaderPartitions
extends PrimitiveOp
implements Operand<String> {
    private Output<String> partitions;

    public static GenerateBigQueryReaderPartitions create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Long numPartitions, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("GenerateBigQueryReaderPartitions", scope.makeOpName("GenerateBigQueryReaderPartitions"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("project_id", projectId);
        opBuilder.setAttr("dataset_id", datasetId);
        opBuilder.setAttr("table_id", tableId);
        String[] columnsArray = new String[columns.size()];
        for (int i = 0; i < columnsArray.length; ++i) {
            columnsArray[i] = columns.get(i);
        }
        opBuilder.setAttr("columns", columnsArray);
        opBuilder.setAttr("timestamp_millis", timestampMillis);
        opBuilder.setAttr("num_partitions", numPartitions);
        if (options != null) {
            for (Options opts : options) {
                if (opts.testEndPoint == null) continue;
                opBuilder.setAttr("test_end_point", opts.testEndPoint);
            }
        }
        return new GenerateBigQueryReaderPartitions(opBuilder.build());
    }

    public static Options testEndPoint(String testEndPoint) {
        return new Options().testEndPoint(testEndPoint);
    }

    public Output<String> partitions() {
        return this.partitions;
    }

    @Override
    public Output<String> asOutput() {
        return this.partitions;
    }

    private GenerateBigQueryReaderPartitions(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.partitions = operation.output(outputIdx++);
    }

    public static class Options {
        private String testEndPoint;

        public Options testEndPoint(String testEndPoint) {
            this.testEndPoint = testEndPoint;
            return this;
        }

        private Options() {
        }
    }
}

