/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ConfigureDistributedTPU
extends PrimitiveOp
implements Operand<String> {
    private Output<String> topology;

    public static ConfigureDistributedTPU create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ConfigureDistributedTPU", scope.makeOpName("ConfigureDistributedTPU"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.embeddingConfig != null) {
                    opBuilder.setAttr("embedding_config", opts.embeddingConfig);
                }
                if (opts.tpuEmbeddingConfig != null) {
                    opBuilder.setAttr("tpu_embedding_config", opts.tpuEmbeddingConfig);
                }
                if (opts.isGlobalInit == null) continue;
                opBuilder.setAttr("is_global_init", opts.isGlobalInit);
            }
        }
        return new ConfigureDistributedTPU(opBuilder.build());
    }

    public static Options embeddingConfig(String embeddingConfig) {
        return new Options().embeddingConfig(embeddingConfig);
    }

    public static Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
        return new Options().tpuEmbeddingConfig(tpuEmbeddingConfig);
    }

    public static Options isGlobalInit(Boolean isGlobalInit) {
        return new Options().isGlobalInit(isGlobalInit);
    }

    public Output<String> topology() {
        return this.topology;
    }

    @Override
    public Output<String> asOutput() {
        return this.topology;
    }

    private ConfigureDistributedTPU(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.topology = operation.output(outputIdx++);
    }

    public static class Options {
        private String embeddingConfig;
        private String tpuEmbeddingConfig;
        private Boolean isGlobalInit;

        public Options embeddingConfig(String embeddingConfig) {
            this.embeddingConfig = embeddingConfig;
            return this;
        }

        public Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
            this.tpuEmbeddingConfig = tpuEmbeddingConfig;
            return this;
        }

        public Options isGlobalInit(Boolean isGlobalInit) {
            this.isGlobalInit = isGlobalInit;
            return this;
        }

        private Options() {
        }
    }
}

