/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.ArrayList;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Operand;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.NameScope;

public final class Scope {
    private final ExecutionEnvironment env;
    private final Iterable<Operand<?>> controlDependencies;
    private final NameScope nameScope;

    public Scope(ExecutionEnvironment env) {
        this(env, new NameScope(), new ArrayList());
    }

    public ExecutionEnvironment env() {
        return this.env;
    }

    public Scope withSubScope(String childScopeName) {
        return new Scope(this.env, this.nameScope.withSubScope(childScopeName), this.controlDependencies);
    }

    public Scope withName(String opName) {
        return new Scope(this.env, this.nameScope.withName(opName), this.controlDependencies);
    }

    public String makeOpName(String defaultName) {
        return this.nameScope.makeOpName(defaultName);
    }

    private Scope(ExecutionEnvironment env, NameScope nameScope, Iterable<Operand<?>> controlDependencies) {
        this.env = env;
        this.nameScope = nameScope;
        this.controlDependencies = controlDependencies;
    }

    public Scope withControlDependencies(Iterable<Operand<?>> controls) {
        return new Scope(this.env, this.nameScope, controls);
    }

    public OperationBuilder applyControlDependencies(OperationBuilder builder) {
        for (Operand<?> control : this.controlDependencies) {
            builder = builder.addControlInput(control.asOutput().op());
        }
        return builder;
    }
}

