/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

public final class GraphOperationBuilder
implements OperationBuilder {
    private long unsafeNativeHandle;
    private Graph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphOperationBuilder(Graph graph, String type, String name) {
        this.graph = graph;
        try (Graph.Reference r = graph.ref();){
            this.unsafeNativeHandle = GraphOperationBuilder.allocate(r.nativeHandle(), type, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperation build() {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperation op = new GraphOperation(this.graph, GraphOperationBuilder.finish(this.unsafeNativeHandle));
            this.unsafeNativeHandle = 0L;
            GraphOperation graphOperation = op;
            return graphOperation;
        }
    }

    @Override
    public GraphOperationBuilder addControlInput(Operation control) {
        if (!(control instanceof GraphOperation)) {
            throw new IllegalArgumentException("Only GraphOperation instances can be used as control inputs");
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.addControlInput(this.unsafeNativeHandle, ((GraphOperation)control).getUnsafeNativeHandle());
        }
        return this;
    }

    @Override
    public GraphOperationBuilder addInput(Output<?> input) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.addInput(this.unsafeNativeHandle, input.getUnsafeNativeHandle(), input.index());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder addInputList(Output<?>[] inputs) {
        try (Graph.Reference r = this.graph.ref();){
            long[] opHandles = new long[inputs.length];
            int[] indices = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                opHandles[i] = inputs[i].getUnsafeNativeHandle();
                indices[i] = inputs[i].index();
            }
            GraphOperationBuilder.addInputList(this.unsafeNativeHandle, opHandles, indices);
        }
        return this;
    }

    @Override
    public GraphOperationBuilder setDevice(String device) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setDevice(this.unsafeNativeHandle, device);
        }
        return this;
    }

    @Override
    public GraphOperationBuilder setAttr(String name, String value) {
        this.setAttr(name, value.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, byte[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrString(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, long value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrInt(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, long[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrIntList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, float value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFloat(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, float[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFloatList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, boolean value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrBool(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, boolean[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrBoolList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, DataType value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrType(this.unsafeNativeHandle, name, value.c());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, DataType[] value) {
        int[] ctypes = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            ctypes[i] = value[i].c();
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTypeList(this.unsafeNativeHandle, name, ctypes);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Tensor<?> value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTensor(this.unsafeNativeHandle, name, value.getNativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Tensor<?>[] value) {
        long[] handles = new long[value.length];
        int idx = 0;
        for (Tensor<?> t : value) {
            handles[idx++] = t.getNativeHandle();
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTensorList(this.unsafeNativeHandle, name, handles);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Shape value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrShape(this.unsafeNativeHandle, name, value.asArray(), value.numDimensions());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Shape[] value) {
        int[] numDimensions = new int[value.length];
        int totalNumDimensions = 0;
        for (int idx = 0; idx < value.length; ++idx) {
            int n;
            numDimensions[idx] = n = value[idx].numDimensions();
            if (n <= 0) continue;
            totalNumDimensions += n;
        }
        long[] shapes = new long[totalNumDimensions];
        int shapeIdx = 0;
        for (Shape shape : value) {
            if (shape.numDimensions() <= 0) continue;
            for (long dim : shape.asArray()) {
                shapes[shapeIdx++] = dim;
            }
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrShapeList(this.unsafeNativeHandle, name, shapes, numDimensions);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, String[] value) {
        Charset utf8 = Charset.forName("UTF-8");
        Object[] objects = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            objects[i] = value[i].getBytes(utf8);
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrStringList(this.unsafeNativeHandle, name, objects);
        }
        return this;
    }

    private static native long allocate(long var0, String var2, String var3);

    private static native long finish(long var0);

    private static native void addInput(long var0, long var2, int var4);

    private static native void addInputList(long var0, long[] var2, int[] var3);

    private static native void addControlInput(long var0, long var2);

    private static native void setDevice(long var0, String var2);

    private static native void setAttrString(long var0, String var2, byte[] var3);

    private static native void setAttrInt(long var0, String var2, long var3);

    private static native void setAttrIntList(long var0, String var2, long[] var3);

    private static native void setAttrFloat(long var0, String var2, float var3);

    private static native void setAttrFloatList(long var0, String var2, float[] var3);

    private static native void setAttrBool(long var0, String var2, boolean var3);

    private static native void setAttrBoolList(long var0, String var2, boolean[] var3);

    private static native void setAttrType(long var0, String var2, int var3);

    private static native void setAttrTypeList(long var0, String var2, int[] var3);

    private static native void setAttrTensor(long var0, String var2, long var3);

    private static native void setAttrTensorList(long var0, String var2, long[] var3);

    private static native void setAttrShape(long var0, String var2, long[] var3, int var4);

    private static native void setAttrShapeList(long var0, String var2, long[] var3, int[] var4);

    private static native void setAttrStringList(long var0, String var2, Object[] var3);
}

