/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tensorflow.DataType;
import org.tensorflow.EagerOperation;
import org.tensorflow.EagerSession;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

final class EagerOperationBuilder
implements OperationBuilder {
    private final EagerSession session;
    private final String type;
    private final String name;
    private final NativeReference nativeRef;

    EagerOperationBuilder(EagerSession session, String type, String name) {
        this.session = session;
        this.type = type;
        this.name = name;
        this.nativeRef = new NativeReference(session, this, EagerOperationBuilder.allocate(session.nativeHandle(), type));
    }

    @Override
    public EagerOperation build() {
        long[] tensorHandles = EagerOperationBuilder.execute(this.nativeRef.opHandle);
        EagerOperation operation = new EagerOperation(this.session, this.nativeRef.opHandle, tensorHandles, this.type, this.name);
        this.nativeRef.clear();
        return operation;
    }

    @Override
    public EagerOperationBuilder addInput(Output<?> input) {
        EagerOperationBuilder.addInput(this.nativeRef.opHandle, input.getUnsafeNativeHandle());
        return this;
    }

    @Override
    public EagerOperationBuilder addInputList(Output<?>[] inputs) {
        long[] inputHandles = new long[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputHandles[i] = inputs[i].getUnsafeNativeHandle();
        }
        EagerOperationBuilder.addInputList(this.nativeRef.opHandle, inputHandles);
        return this;
    }

    @Override
    public OperationBuilder addControlInput(Operation control) {
        throw new UnsupportedOperationException("Control inputs are not supported in an eager execution environment");
    }

    @Override
    public EagerOperationBuilder setDevice(String device) {
        EagerOperationBuilder.setDevice(this.nativeRef.opHandle, device);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, String value) {
        return this.setAttr(name, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public EagerOperationBuilder setAttr(String name, String[] values) {
        Charset utf8 = StandardCharsets.UTF_8;
        Object[] objects = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            objects[i] = values[i].getBytes(utf8);
        }
        EagerOperationBuilder.setAttrStringList(this.nativeRef.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, byte[] values) {
        EagerOperationBuilder.setAttrString(this.nativeRef.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, long value) {
        EagerOperationBuilder.setAttrInt(this.nativeRef.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, long[] values) {
        EagerOperationBuilder.setAttrIntList(this.nativeRef.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, float value) {
        EagerOperationBuilder.setAttrFloat(this.nativeRef.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, float[] values) {
        EagerOperationBuilder.setAttrFloatList(this.nativeRef.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, boolean value) {
        EagerOperationBuilder.setAttrBool(this.nativeRef.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, boolean[] values) {
        EagerOperationBuilder.setAttrBoolList(this.nativeRef.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, DataType value) {
        EagerOperationBuilder.setAttrType(this.nativeRef.opHandle, name, value.c());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, DataType[] values) {
        int[] c = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            c[i] = values[i].c();
        }
        EagerOperationBuilder.setAttrTypeList(this.nativeRef.opHandle, name, c);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Tensor<?> value) {
        EagerOperationBuilder.setAttrTensor(this.nativeRef.opHandle, name, value.getNativeHandle());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Tensor<?>[] values) {
        throw new UnsupportedOperationException("Tensor list attributes are not supported in eager mode");
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Shape value) {
        EagerOperationBuilder.setAttrShape(this.nativeRef.opHandle, name, value.asArray(), value.numDimensions());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Shape[] values) {
        int[] numDimensions = new int[values.length];
        int totalNumDimensions = 0;
        for (int idx = 0; idx < values.length; ++idx) {
            int n;
            numDimensions[idx] = n = values[idx].numDimensions();
            if (n <= 0) continue;
            totalNumDimensions += n;
        }
        long[] shapes = new long[totalNumDimensions];
        int shapeIdx = 0;
        for (Shape shape : values) {
            if (shape.numDimensions() <= 0) continue;
            for (long dim : shape.asArray()) {
                shapes[shapeIdx++] = dim;
            }
        }
        EagerOperationBuilder.setAttrShapeList(this.nativeRef.opHandle, name, shapes, numDimensions);
        return this;
    }

    private static native long allocate(long var0, String var2);

    private static native void delete(long var0);

    private static native long[] execute(long var0);

    private static native void addInput(long var0, long var2);

    private static native void addInputList(long var0, long[] var2);

    private static native void setDevice(long var0, String var2);

    private static native void setAttrString(long var0, String var2, byte[] var3);

    private static native void setAttrStringList(long var0, String var2, Object[] var3);

    private static native void setAttrInt(long var0, String var2, long var3);

    private static native void setAttrIntList(long var0, String var2, long[] var3);

    private static native void setAttrFloat(long var0, String var2, float var3);

    private static native void setAttrFloatList(long var0, String var2, float[] var3);

    private static native void setAttrBool(long var0, String var2, boolean var3);

    private static native void setAttrBoolList(long var0, String var2, boolean[] var3);

    private static native void setAttrType(long var0, String var2, int var3);

    private static native void setAttrTypeList(long var0, String var2, int[] var3);

    private static native void setAttrTensor(long var0, String var2, long var3);

    private static native void setAttrShape(long var0, String var2, long[] var3, int var4);

    private static native void setAttrShapeList(long var0, String var2, long[] var3, int[] var4);

    private static class NativeReference
    extends EagerSession.NativeReference {
        private long opHandle;

        NativeReference(EagerSession session, EagerOperationBuilder operation, long opHandle) {
            super(session, operation);
            this.opHandle = opHandle;
        }

        @Override
        public void clear() {
            super.clear();
            this.opHandle = 0L;
        }

        @Override
        synchronized void delete() {
            if (this.opHandle != 0L) {
                EagerOperationBuilder.delete(this.opHandle);
                this.opHandle = 0L;
            }
        }
    }
}

