/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Greedily selects a subset of bounding boxes in descending order of score,
 * <p>
 * pruning away boxes that have high intersection-over-union (IOU) overlap
 * with previously selected boxes.  Bounding boxes with score less than
 * `score_threshold` are removed.  Bounding boxes are supplied as
 * [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
 * diagonal pair of box corners and the coordinates can be provided as normalized
 * (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
 * is agnostic to where the origin is in the coordinate system and more
 * generally is invariant to orthogonal transformations and translations
 * of the coordinate system; thus translating or reflections of the coordinate
 * system result in the same boxes being selected by the algorithm.
 * The output of this operation is a set of integers indexing into the input
 * collection of bounding boxes representing the selected boxes.  The bounding
 * box coordinates corresponding to the selected indices can then be obtained
 * using the `tf.gather operation`.  For example:
 *   selected_indices = tf.image.non_max_suppression_v2(
 *       boxes, scores, max_output_size, iou_threshold, score_threshold)
 *   selected_boxes = tf.gather(boxes, selected_indices)
 */
@Operator(group = "image")
public final class NonMaxSuppression extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.image.NonMaxSuppression}
   */
  public static class Options {
    
    /**
     * @param padToMaxOutputSize If true, the output `selected_indices` is padded to be of length
     * `max_output_size`. Defaults to false.
     */
    public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
      this.padToMaxOutputSize = padToMaxOutputSize;
      return this;
    }
    
    private Boolean padToMaxOutputSize;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class wrapping a new NonMaxSuppression operation.
   * 
   * @param scope current scope
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * score corresponding to each box (each row of boxes).
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * boxes to be selected by non max suppression.
   * @param iouThreshold A 0-D float tensor representing the threshold for deciding whether
   * boxes overlap too much with respect to IOU.
   * @param scoreThreshold A 0-D float tensor representing the threshold for deciding when to remove
   * boxes based on score.
   * @param options carries optional attributes values
   * @return a new instance of NonMaxSuppression
   */
  public static <T extends Number> NonMaxSuppression create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold, Options... options) {
    OperationBuilder opBuilder = scope.env().opBuilder("NonMaxSuppressionV4", scope.makeOpName("NonMaxSuppression"));
    opBuilder.addInput(boxes.asOutput());
    opBuilder.addInput(scores.asOutput());
    opBuilder.addInput(maxOutputSize.asOutput());
    opBuilder.addInput(iouThreshold.asOutput());
    opBuilder.addInput(scoreThreshold.asOutput());
    opBuilder = scope.applyControlDependencies(opBuilder);
    if (options != null) {
      for (Options opts : options) {
        if (opts.padToMaxOutputSize != null) {
          opBuilder.setAttr("pad_to_max_output_size", opts.padToMaxOutputSize);
        }
      }
    }
    return new NonMaxSuppression(opBuilder.build());
  }
  
  /**
   * @param padToMaxOutputSize If true, the output `selected_indices` is padded to be of length
   * `max_output_size`. Defaults to false.
   */
  public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
    return new Options().padToMaxOutputSize(padToMaxOutputSize);
  }
  
  /**
   * A 1-D integer tensor of shape `[M]` representing the selected
   * indices from the boxes tensor, where `M <= max_output_size`.
   */
  public Output<Integer> selectedIndices() {
    return selectedIndices;
  }
  
  /**
   * A 0-D integer tensor representing the number of valid elements in
   * `selected_indices`, with the valid elements appearing first.
   */
  public Output<Integer> validOutputs() {
    return validOutputs;
  }
  
  private Output<Integer> selectedIndices;
  private Output<Integer> validOutputs;
  
  private NonMaxSuppression(Operation operation) {
    super(operation);
    int outputIdx = 0;
    selectedIndices = operation.output(outputIdx++);
    validOutputs = operation.output(outputIdx++);
  }
}
