/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Generates serialized partition messages suitable for batch reads.
 * <p>
 * This op should not be used directly by clients. Instead, the
 * bigquery_reader_ops.py file defines a clean interface to the reader.
 */
@Operator
public final class GenerateBigQueryReaderPartitions extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.GenerateBigQueryReaderPartitions}
   */
  public static class Options {
    
    /**
     * @param testEndPoint Do not use. For testing purposes only.
     */
    public Options testEndPoint(String testEndPoint) {
      this.testEndPoint = testEndPoint;
      return this;
    }
    
    private String testEndPoint;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class wrapping a new GenerateBigQueryReaderPartitions operation.
   * 
   * @param scope current scope
   * @param projectId GCP project ID.
   * @param datasetId BigQuery Dataset ID.
   * @param tableId Table to read.
   * @param columns List of columns to read. Leave empty to read all columns.
   * @param timestampMillis Table snapshot timestamp in millis since epoch. Relative
   * (negative or zero) snapshot times are not allowed. For more details, see
   * 'Table Decorators' in BigQuery docs.
   * @param numPartitions Number of partitions to split the table into.
   * @param options carries optional attributes values
   * @return a new instance of GenerateBigQueryReaderPartitions
   */
  public static GenerateBigQueryReaderPartitions create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Long numPartitions, Options... options) {
    OperationBuilder opBuilder = scope.env().opBuilder("GenerateBigQueryReaderPartitions", scope.makeOpName("GenerateBigQueryReaderPartitions"));
    opBuilder = scope.applyControlDependencies(opBuilder);
    opBuilder.setAttr("project_id", projectId);
    opBuilder.setAttr("dataset_id", datasetId);
    opBuilder.setAttr("table_id", tableId);
    String[] columnsArray = new String[columns.size()];
    for (int i = 0; i < columnsArray.length; ++i) {
      columnsArray[i] = columns.get(i);
    }
    opBuilder.setAttr("columns", columnsArray);
    opBuilder.setAttr("timestamp_millis", timestampMillis);
    opBuilder.setAttr("num_partitions", numPartitions);
    if (options != null) {
      for (Options opts : options) {
        if (opts.testEndPoint != null) {
          opBuilder.setAttr("test_end_point", opts.testEndPoint);
        }
      }
    }
    return new GenerateBigQueryReaderPartitions(opBuilder.build());
  }
  
  /**
   * @param testEndPoint Do not use. For testing purposes only.
   */
  public static Options testEndPoint(String testEndPoint) {
    return new Options().testEndPoint(testEndPoint);
  }
  
  /**
   * Serialized table partitions.
   */
  public Output<String> partitions() {
    return partitions;
  }
  
  @Override
  public Output<String> asOutput() {
    return partitions;
  }
  
  private Output<String> partitions;
  
  private GenerateBigQueryReaderPartitions(Operation operation) {
    super(operation);
    int outputIdx = 0;
    partitions = operation.output(outputIdx++);
  }
}
