/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.botapimethods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BotApiMethodSerializable
extends BotApiMethod<Serializable> {
    public Serializable deserializeResponseMessageOrBoolean(String answer) throws TelegramApiRequestException {
        return this.deserializeResponseFromPossibilities(answer, Arrays.asList(Message.class, Boolean.class));
    }

    public Serializable deserializeResponseFromPossibilities(String answer, List<Class<? extends Serializable>> possibleValues) throws TelegramApiRequestException {
        Throwable lastException = null;
        for (Class<? extends Serializable> possibleValue : possibleValues) {
            try {
                return this.deserializeResponseSerializable(answer, possibleValue);
            }
            catch (TelegramApiRequestException e) {
                if (e.getCause() instanceof IOException) {
                    lastException = e.getCause();
                    continue;
                }
                throw e;
            }
        }
        throw new TelegramApiRequestException("Unable to deserialize response", lastException);
    }

    protected BotApiMethodSerializable(BotApiMethodSerializableBuilder<?, ?> b) {
        super(b);
    }

    protected BotApiMethodSerializable() {
    }

    public static abstract class BotApiMethodSerializableBuilder<C extends BotApiMethodSerializable, B extends BotApiMethodSerializableBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<Serializable, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BotApiMethodSerializable.BotApiMethodSerializableBuilder(super=" + super.toString() + ")";
        }
    }
}

