/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta;

public class TelegramUrl {
    private String schema;
    private String host;
    private int port;
    public static final TelegramUrl DEFAULT_URL = new TelegramUrl("https", "api.telegram.org", 443);

    public static TelegramUrlBuilder builder() {
        return new TelegramUrlBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelegramUrl)) {
            return false;
        }
        TelegramUrl other = (TelegramUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TelegramUrl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "TelegramUrl(schema=" + this.getSchema() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public TelegramUrl(String schema, String host, int port) {
        this.schema = schema;
        this.host = host;
        this.port = port;
    }

    public TelegramUrl() {
    }

    public static class TelegramUrlBuilder {
        private String schema;
        private String host;
        private int port;

        TelegramUrlBuilder() {
        }

        public TelegramUrlBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public TelegramUrlBuilder host(String host) {
            this.host = host;
            return this;
        }

        public TelegramUrlBuilder port(int port) {
            this.port = port;
            return this;
        }

        public TelegramUrl build() {
            return new TelegramUrl(this.schema, this.host, this.port);
        }

        public String toString() {
            return "TelegramUrl.TelegramUrlBuilder(schema=" + this.schema + ", host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

