/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.switchyard.common.CommonCoreLogger;
import org.switchyard.common.type.classpath.Filter;

public class ClasspathScanner {
    private static Logger _logger = Logger.getLogger(ClasspathScanner.class);
    private Filter _filter;

    public ClasspathScanner(Filter filter) {
        this._filter = filter;
    }

    public void scan(URL url) throws IOException {
        File file = ClasspathScanner.toClassPathFile(url);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.handleDirectory(file, url.getRef());
            } else {
                this.handleArchive(file);
            }
        } else {
            CommonCoreLogger.ROOT_LOGGER.unknownClasspathURL(file.getAbsolutePath());
        }
    }

    public static File toClassPathFile(URL classPathURL) throws IOException {
        String urlPath = null;
        try {
            urlPath = classPathURL.toURI().getPath();
        }
        catch (URISyntaxException use) {
            urlPath = classPathURL.getFile();
        }
        String urlRef = classPathURL.getRef();
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.indexOf(33));
        }
        return urlRef == null || urlRef.length() == 0 ? new File(urlPath) : new File(urlPath, urlRef);
    }

    private void handleArchive(File file) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Scanning archive: " + file.getAbsolutePath()));
        }
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                if (!this._filter.continueScanning()) {
                    break;
                }
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this._filter.filter(name);
            }
        }
    }

    private void handleDirectory(File file, String path) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Scanning directory: " + file.getAbsolutePath()));
        }
        for (File child : file.listFiles()) {
            String newPath;
            if (!this._filter.continueScanning()) break;
            String string = newPath = path == null || path.isEmpty() ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this._filter.filter(newPath);
        }
    }
}

