/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;

public abstract class Puller<R> {
    public R pull(String resource) throws IOException {
        return this.pull(resource, this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(String resource, Class<?> caller) throws IOException {
        InputStream is = Classes.getResourceAsStream(resource, caller);
        if (is != null) {
            try {
                R r = this.pull(is);
                return r;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(String resource, ClassLoader loader) throws IOException {
        InputStream is = Classes.getResourceAsStream(resource, loader);
        if (is != null) {
            try {
                R r = this.pull(is);
                return r;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    public R pull(URI uri) throws IOException {
        return this.pull(uri.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            R r = this.pull(is);
            return r;
        }
    }

    public R pull(Resource resource) throws IOException {
        return this.pull(resource, this.getClass());
    }

    public R pull(Resource resource, Class<?> caller) throws IOException {
        return this.pull(resource.getLocationURL(caller));
    }

    public R pull(Resource resource, ClassLoader loader) throws IOException {
        return this.pull(resource.getLocationURL(loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pull(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            R r = this.pull(is);
            return r;
        }
    }

    public abstract R pull(InputStream var1) throws IOException;

    public R pullPath(String path, PathType ... pathTypes) {
        return this.pullPath(path, this.getClass(), pathTypes);
    }

    public R pullPath(String path, Class<?> caller, PathType ... pathTypes) {
        return this.pullPath(path, caller, null, true, pathTypes);
    }

    public R pullPath(String path, ClassLoader loader, PathType ... pathTypes) {
        return this.pullPath(path, null, loader, false, pathTypes);
    }

    private R pullPath(String path, Class<?> caller, ClassLoader loader, boolean callerOrLoader, PathType[] pathTypes) {
        if (path == null) {
            return null;
        }
        R r = null;
        for (PathType pathType : pathTypes) {
            if (pathType == null) continue;
            try {
                switch (pathType) {
                    case CLASS: {
                        if (callerOrLoader) {
                            r = this.pull(path, caller);
                            break;
                        }
                        r = this.pull(path, loader);
                        break;
                    }
                    case FILE: {
                        File file;
                        try {
                            file = new File(new URL(path).getFile());
                        }
                        catch (MalformedURLException mue) {
                            file = new File(path);
                        }
                        if (!file.exists() || !file.isFile()) break;
                        r = this.pull(file);
                        break;
                    }
                    case URI: {
                        r = this.pull(new URI(path));
                        break;
                    }
                    case URL: {
                        r = this.pull(new URL(path));
                    }
                }
            }
            catch (Throwable t) {
                t.getMessage();
            }
            if (r != null) break;
        }
        return r;
    }

    public static enum PathType {
        CLASS,
        FILE,
        URI,
        URL;

    }
}

