/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Optional;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.ServerRequest;

@FunctionalInterface
public interface RequestPredicate {
    public boolean test(ServerRequest var1);

    default public RequestPredicate and(RequestPredicate other) {
        return new RequestPredicates.AndRequestPredicate(this, other);
    }

    default public RequestPredicate negate() {
        return t -> !this.test(t);
    }

    default public RequestPredicate or(RequestPredicate other) {
        return new RequestPredicates.OrRequestPredicate(this, other);
    }

    default public Optional<ServerRequest> nest(ServerRequest request) {
        return this.test(request) ? Optional.of(request) : Optional.empty();
    }
}

