/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OkHttpClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

class OkHttpClientHttpRequest
extends AbstractBufferingAsyncClientHttpRequest
implements ClientHttpRequest {
    private final OkHttpClient client;
    private final URI uri;
    private final HttpMethod method;

    public OkHttpClientHttpRequest(OkHttpClient client, URI uri, HttpMethod method) {
        this.client = client;
        this.uri = uri;
        this.method = method;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ListenableFuture<ClientHttpResponse> executeInternal(HttpHeaders headers, byte[] content) throws IOException {
        MediaType contentType = this.getContentType(headers);
        RequestBody body = content.length > 0 ? RequestBody.create((MediaType)contentType, (byte[])content) : null;
        URL url = this.uri.toURL();
        String methodName = this.method.name();
        Request.Builder builder = new Request.Builder().url(url).method(methodName, body);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                builder.addHeader(headerName, headerValue);
            }
        }
        Request request = builder.build();
        return new OkHttpListenableFuture(this.client.newCall(request));
    }

    private MediaType getContentType(HttpHeaders headers) {
        String rawContentType = headers.getFirst("Content-Type");
        return StringUtils.hasText((String)rawContentType) ? MediaType.parse((String)rawContentType) : null;
    }

    @Override
    public ClientHttpResponse execute() throws IOException {
        try {
            return (ClientHttpResponse)this.executeAsync().get();
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.getMessage(), cause);
        }
    }

    private static class OkHttpListenableFuture
    extends SettableListenableFuture<ClientHttpResponse> {
        private final Call call;

        public OkHttpListenableFuture(Call call) {
            this.call = call;
            this.call.enqueue(new Callback(){

                public void onResponse(Response response) {
                    OkHttpListenableFuture.this.set(new OkHttpClientHttpResponse(response));
                }

                public void onFailure(Request request, IOException ex) {
                    OkHttpListenableFuture.this.setException(ex);
                }
            });
        }

        protected void interruptTask() {
            this.call.cancel();
        }
    }
}

