/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.modulith.test.DefaultAssertablePublishedEvents;
import org.springframework.modulith.test.DefaultPublishedEvents;
import org.springframework.modulith.test.PublishedEvents;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class PublishedEventsParameterResolver
implements ParameterResolver,
AfterEachCallback {
    private static final boolean ASSERT_J_PRESENT = ClassUtils.isPresent((String)"org.assertj.core.api.Assert", (ClassLoader)PublishedEventsParameterResolver.class.getClassLoader());
    private ThreadBoundApplicationListenerAdapter listener;
    private final Function<ExtensionContext, ApplicationContext> lookup;

    PublishedEventsParameterResolver() {
        this(ctx -> SpringExtension.getApplicationContext((ExtensionContext)ctx));
    }

    PublishedEventsParameterResolver(Function<ExtensionContext, ApplicationContext> supplier) {
        this.lookup = supplier;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        if (type.getName().equals("org.springframework.modulith.test.AssertablePublishedEvents") && !ASSERT_J_PRESENT) {
            throw new IllegalStateException("Method declares AssertablePublishedEvents as parameter but AssertJ is not on the classpath!");
        }
        return PublishedEvents.class.isAssignableFrom(type);
    }

    public PublishedEvents resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        PublishedEvents publishedEvents = ASSERT_J_PRESENT ? new DefaultAssertablePublishedEvents() : new DefaultPublishedEvents();
        this.initializeListener(extensionContext);
        this.listener.registerDelegate((ApplicationListener<ApplicationEvent>)publishedEvents);
        return publishedEvents;
    }

    private void initializeListener(ExtensionContext extensionContext) {
        if (this.listener != null) {
            return;
        }
        ApplicationContext context = this.lookup.apply(extensionContext);
        if (!(context instanceof AbstractApplicationContext)) {
            throw new IllegalStateException();
        }
        AbstractApplicationContext aac = (AbstractApplicationContext)context;
        this.listener = aac.getApplicationListeners().stream().filter(ThreadBoundApplicationListenerAdapter.class::isInstance).map(ThreadBoundApplicationListenerAdapter.class::cast).findFirst().orElseGet(() -> {
            ThreadBoundApplicationListenerAdapter adapter = new ThreadBoundApplicationListenerAdapter();
            aac.addApplicationListener((ApplicationListener)adapter);
            return adapter;
        });
    }

    public void afterEach(ExtensionContext context) {
        if (this.listener != null) {
            this.listener.unregisterDelegate();
        }
    }

    private static class ThreadBoundApplicationListenerAdapter
    implements ApplicationListener<ApplicationEvent> {
        private final ThreadLocal<ApplicationListener<ApplicationEvent>> delegate = new InheritableThreadLocal<ApplicationListener<ApplicationEvent>>();

        private ThreadBoundApplicationListenerAdapter() {
        }

        void registerDelegate(ApplicationListener<ApplicationEvent> listener) {
            Assert.notNull(listener, (String)"Delegate ApplicationListener must not be null!");
            this.delegate.set(listener);
        }

        void unregisterDelegate() {
            this.delegate.remove();
        }

        public void onApplicationEvent(ApplicationEvent event) {
            ApplicationListener<ApplicationEvent> listener = this.delegate.get();
            if (listener != null) {
                listener.onApplicationEvent(event);
            }
        }
    }
}

