/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.core;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.jpa.core.DefaultJpaOperations;
import org.springframework.integration.jpa.core.JpaOperations;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.PersistMode;
import org.springframework.integration.jpa.support.parametersource.BeanPropertyParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JpaExecutor
implements InitializingBean,
BeanFactoryAware {
    private final JpaOperations jpaOperations;
    private List<JpaParameter> jpaParameters;
    private Class<?> entityClass;
    private String jpaQuery;
    private String nativeQuery;
    private String namedQuery;
    private Expression maxResultsExpression;
    private Expression firstResultExpression;
    private Expression idExpression;
    private PersistMode persistMode = PersistMode.MERGE;
    private ParameterSourceFactory parameterSourceFactory = null;
    private ParameterSource parameterSource;
    private boolean flush = false;
    private int flushSize = 0;
    private boolean clearOnFlush = false;
    private boolean deleteAfterPoll = false;
    private boolean deleteInBatch = false;
    private boolean expectSingleResult = false;
    private Boolean usePayloadAsParameterSource = null;
    private BeanFactory beanFactory;
    private EvaluationContext evaluationContext;

    public JpaExecutor(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"entityManagerFactory must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManagerFactory(entityManagerFactory);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManager(entityManager);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(JpaOperations jpaOperations) {
        Assert.notNull((Object)jpaOperations, (String)"jpaOperations must not be null.");
        this.jpaOperations = jpaOperations;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass must not be null.");
        this.entityClass = entityClass;
    }

    public void setJpaQuery(String jpaQuery) {
        Assert.isTrue((this.nativeQuery == null && this.namedQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)jpaQuery, (String)"jpaQuery must neither be null nor empty.");
        this.jpaQuery = jpaQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        Assert.isTrue((this.namedQuery == null && this.jpaQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)nativeQuery, (String)"nativeQuery must neither be null nor empty.");
        this.nativeQuery = nativeQuery;
    }

    public void setNamedQuery(String namedQuery) {
        Assert.isTrue((this.jpaQuery == null && this.nativeQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)namedQuery, (String)"namedQuery must neither be null nor empty.");
        this.namedQuery = namedQuery;
    }

    public void setPersistMode(PersistMode persistMode) {
        this.persistMode = persistMode;
    }

    public void setJpaParameters(List<JpaParameter> jpaParameters) {
        this.jpaParameters = jpaParameters;
    }

    public void setUsePayloadAsParameterSource(Boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setFlushSize(int flushSize) {
        Assert.state((flushSize >= 0 ? 1 : 0) != 0, (String)"'flushSize' cannot be less than '0'.");
        this.flushSize = flushSize;
    }

    public void setClearOnFlush(boolean clearOnFlush) {
        this.clearOnFlush = clearOnFlush;
    }

    public void setDeleteInBatch(boolean deleteInBatch) {
        this.deleteInBatch = deleteInBatch;
    }

    public void setDeleteAfterPoll(boolean deleteAfterPoll) {
        this.deleteAfterPoll = deleteAfterPoll;
    }

    public void setParameterSourceFactory(ParameterSourceFactory parameterSourceFactory) {
        Assert.notNull((Object)parameterSourceFactory, (String)"parameterSourceFactory must not be null.");
        this.parameterSourceFactory = parameterSourceFactory;
    }

    public void setParameterSource(ParameterSource parameterSource) {
        Assert.notNull((Object)parameterSource, (String)"parameterSource must not be null.");
        this.parameterSource = parameterSource;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setFirstResultExpression(Expression firstResultExpression) {
        this.firstResultExpression = firstResultExpression;
    }

    public void setIdExpression(Expression idExpression) {
        this.idExpression = idExpression;
    }

    public void setMaxResultsExpression(Expression maxResultsExpression) {
        Assert.notNull((Object)maxResultsExpression, (String)"maxResultsExpression cannot be null");
        this.maxResultsExpression = maxResultsExpression;
    }

    public void setMaxNumberOfResults(int maxNumberOfResults) {
        this.setMaxResultsExpression((Expression)new ValueExpression((Object)maxNumberOfResults));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (!CollectionUtils.isEmpty(this.jpaParameters)) {
            if (this.parameterSourceFactory != null) {
                throw new IllegalStateException("The 'jpaParameters' and 'parameterSourceFactory' are mutually exclusive. Consider to configure parameters on the provided 'parameterSourceFactory': " + this.parameterSourceFactory);
            }
            ExpressionEvaluatingParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingParameterSourceFactory(this.beanFactory);
            expressionSourceFactory.setParameters(this.jpaParameters);
            this.parameterSourceFactory = expressionSourceFactory;
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.parameterSourceFactory == null) {
                this.parameterSourceFactory = new BeanPropertyParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
        if (this.flushSize > 0) {
            this.flush = true;
        } else if (this.flush) {
            this.flushSize = 1;
        }
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
    }

    public Object executeOutboundJpaOperation(Message<?> message) {
        ParameterSource paramSource = null;
        if (this.jpaQuery != null || this.nativeQuery != null || this.namedQuery != null) {
            paramSource = this.determineParameterSource(message);
        }
        if (this.jpaQuery != null) {
            return this.jpaOperations.executeUpdate(this.jpaQuery, paramSource);
        }
        if (this.nativeQuery != null) {
            return this.jpaOperations.executeUpdateWithNativeQuery(this.nativeQuery, paramSource);
        }
        if (this.namedQuery != null) {
            return this.jpaOperations.executeUpdateWithNamedQuery(this.namedQuery, paramSource);
        }
        return this.executeOutboundJpaOperationOnPersistentMode(message);
    }

    private Object executeOutboundJpaOperationOnPersistentMode(Message<?> message) {
        Object payload = message.getPayload();
        switch (this.persistMode) {
            case PERSIST: {
                this.jpaOperations.persist(payload, this.flushSize, this.clearOnFlush);
                return payload;
            }
            case MERGE: {
                return this.jpaOperations.merge(payload, this.flushSize, this.clearOnFlush);
            }
            case DELETE: {
                if (payload instanceof Iterable) {
                    this.jpaOperations.deleteInBatch((Iterable)payload);
                } else {
                    this.jpaOperations.delete(payload);
                }
                if (this.flush) {
                    this.jpaOperations.flush();
                }
                return payload;
            }
        }
        throw new IllegalStateException("Unsupported PersistMode: " + this.persistMode.name());
    }

    @Nullable
    public Object poll() {
        return this.poll(null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object poll(@Nullable Message<?> requestMessage) {
        void var2_10;
        block12: {
            if (this.idExpression != null) {
                Object id = this.idExpression.getValue(this.evaluationContext, requestMessage);
                Assert.state((id != null ? 1 : 0) != 0, (String)"The 'idExpression' cannot evaluate to null.");
                Class<?> entityClazz = this.entityClass;
                if (entityClazz == null && requestMessage != null) {
                    entityClazz = requestMessage.getPayload().getClass();
                }
                Assert.state((entityClazz != null ? 1 : 0) != 0, (String)"The entity class to retrieve cannot be null.");
                Object obj = this.jpaOperations.find(entityClazz, id);
            } else {
                List<?> result;
                int maxNumberOfResults = this.evaluateExpressionForNumericResult(requestMessage, this.maxResultsExpression);
                if (requestMessage == null) {
                    result = this.doPoll(this.parameterSource, 0, maxNumberOfResults);
                } else {
                    int firstResult = 0;
                    if (this.firstResultExpression != null) {
                        firstResult = this.getFirstResult(requestMessage);
                    }
                    ParameterSource paramSource = this.determineParameterSource(requestMessage);
                    result = this.doPoll(paramSource, firstResult, maxNumberOfResults);
                }
                if (result.isEmpty()) {
                    Object var2_7 = null;
                } else {
                    if (this.expectSingleResult) {
                        if (result.size() == 1) {
                            Object obj = result.iterator().next();
                            break block12;
                        } else {
                            if (requestMessage != null) {
                                throw new MessagingException(requestMessage, "The Jpa operation returned more than 1 result for expectSingleResult mode.");
                            }
                            throw new MessagingException("The Jpa operation returned more than 1 result for expectSingleResult mode.");
                        }
                    }
                    List<?> list = result;
                }
            }
        }
        this.checkDelete(var2_10);
        return var2_10;
    }

    private void checkDelete(@Nullable Object payload) {
        if (payload != null && this.deleteAfterPoll) {
            if (payload instanceof Iterable) {
                if (this.deleteInBatch) {
                    this.jpaOperations.deleteInBatch((Iterable)payload);
                } else {
                    for (Object entity : (Iterable)payload) {
                        this.jpaOperations.delete(entity);
                    }
                }
            } else {
                this.jpaOperations.delete(payload);
            }
            if (this.flush) {
                this.jpaOperations.flush();
            }
        }
    }

    protected List<?> doPoll(ParameterSource jpaQLParameterSource, int firstResult, int maxNumberOfResults) {
        List<?> payload;
        if (this.jpaQuery != null) {
            payload = this.jpaOperations.getResultListForQuery(this.jpaQuery, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.nativeQuery != null) {
            payload = this.jpaOperations.getResultListForNativeQuery(this.nativeQuery, this.entityClass, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.namedQuery != null) {
            payload = this.jpaOperations.getResultListForNamedQuery(this.namedQuery, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.entityClass != null) {
            payload = this.jpaOperations.getResultListForClass(this.entityClass, firstResult, maxNumberOfResults);
        } else {
            throw new IllegalStateException("For the polling operation, one of the following properties must be specified: query, namedQuery or entityClass.");
        }
        return payload;
    }

    private int getFirstResult(Message<?> requestMessage) {
        return this.evaluateExpressionForNumericResult(requestMessage, this.firstResultExpression);
    }

    private int evaluateExpressionForNumericResult(@Nullable Message<?> requestMessage, @Nullable Expression expression) {
        Object evaluationResult;
        int evaluatedResult = 0;
        if (expression != null && (evaluationResult = expression.getValue(this.evaluationContext, requestMessage)) != null) {
            if (evaluationResult instanceof Number) {
                evaluatedResult = ((Number)evaluationResult).intValue();
            } else if (evaluationResult instanceof String) {
                try {
                    evaluatedResult = Integer.parseInt((String)evaluationResult);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value " + evaluationResult + " passed as cannot be parsed to a number, expected to be numeric", e);
                }
            } else {
                throw new IllegalArgumentException("Expected the value to be a Number got " + evaluationResult.getClass().getName());
            }
        }
        return evaluatedResult;
    }

    private ParameterSource determineParameterSource(Message<?> requestMessage) {
        if (this.usePayloadAsParameterSource.booleanValue()) {
            return this.parameterSourceFactory.createParameterSource(requestMessage.getPayload());
        }
        return this.parameterSourceFactory.createParameterSource(requestMessage);
    }
}

