/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class HttpRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private final RestTemplate restTemplate;
    private final boolean restTemplateExplicitlySet;

    public HttpRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public HttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public HttpRequestExecutingMessageHandler(String uri, RestTemplate restTemplate) {
        this((Expression)new LiteralExpression(uri), restTemplate);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public HttpRequestExecutingMessageHandler(Expression uriExpression, @Nullable RestTemplate restTemplate) {
        super(uriExpression);
        this.restTemplateExplicitlySet = restTemplate != null;
        RestTemplate restTemplate2 = this.restTemplate = this.restTemplateExplicitlySet ? restTemplate : new RestTemplate();
        if (!this.restTemplateExplicitlySet) {
            this.restTemplate.setUriTemplateHandler((UriTemplateHandler)this.uriFactory);
        }
    }

    public String getComponentType() {
        return this.isExpectReply() ? "http:outbound-gateway" : "http:outbound-channel-adapter";
    }

    private void assertLocalRestTemplate(String option) {
        Assert.isTrue((!this.restTemplateExplicitlySet ? 1 : 0) != 0, () -> "The option '" + option + "' must be provided on the externally configured RestTemplate: " + this.restTemplate);
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.assertLocalRestTemplate("errorHandler");
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.assertLocalRestTemplate("messageConverters");
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.assertLocalRestTemplate("requestFactory");
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public void setEncodingMode(DefaultUriBuilderFactory.EncodingMode encodingMode) {
        this.assertLocalRestTemplate("encodingMode on UriTemplateHandler");
        super.setEncodingMode(encodingMode);
    }

    @Override
    @Nullable
    protected Object exchange(Object uri, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage, Map<String, ?> uriVariables) {
        try {
            ResponseEntity httpResponse = uri instanceof URI ? (expectedResponseType instanceof ParameterizedTypeReference ? this.restTemplate.exchange((URI)uri, httpMethod, httpRequest, (ParameterizedTypeReference)expectedResponseType) : this.restTemplate.exchange((URI)uri, httpMethod, httpRequest, (Class)expectedResponseType)) : (expectedResponseType instanceof ParameterizedTypeReference ? this.restTemplate.exchange((String)uri, httpMethod, httpRequest, (ParameterizedTypeReference)expectedResponseType, uriVariables) : this.restTemplate.exchange((String)uri, httpMethod, httpRequest, (Class)expectedResponseType, uriVariables));
            if (this.isExpectReply()) {
                return this.getReply(httpResponse);
            }
            return null;
        }
        catch (RestClientException e) {
            throw new MessageHandlingException(requestMessage, "HTTP request execution failed for URI [" + uri + "] in the [" + (Object)((Object)this) + ']', (Throwable)e);
        }
    }
}

