/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.BindingImpl;
import com.google.inject.name.Named;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.Order;
import org.springframework.guice.annotation.GuiceFactoryBean;
import org.springframework.guice.annotation.InjectorFactory;
import org.springframework.guice.annotation.ModuleFilter;
import org.springframework.guice.module.SpringModule;

@Configuration(proxyBeanMethods=false)
@Order(value=-2147483648)
class ModuleRegistryConfiguration
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final String SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME = "spring.guice.dedup";
    private static final String SPRING_GUICE_AUTOWIRE_JIT_PROPERTY_NAME = "spring.guice.autowireJIT";
    private static final String SPRING_GUICE_STAGE_PROPERTY_NAME = "spring.guice.stage";
    private static final List<String> SPRING_GUICE_IGNORED_ANNOTATION_PREFIXES = Arrays.asList("com.google.inject.multibindings", "com.google.inject.internal.Element", "com.google.inject.internal.UniqueAnnotations", "com.google.inject.internal.RealOptionalBinder");
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private boolean enableJustInTimeBinding = true;
    protected static final Method GUICE_BINDINGIMPL_WITHKEY;

    ModuleRegistryConfiguration() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.enableJustInTimeBinding = (Boolean)applicationContext.getEnvironment().getProperty(SPRING_GUICE_AUTOWIRE_JIT_PROPERTY_NAME, Boolean.class, (Object)true);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        List<Module> modules = this.filterModules(registry, new ArrayList<Module>(((ConfigurableListableBeanFactory)registry).getBeansOfType(Module.class).values()));
        SpringModule module = new SpringModule((ConfigurableListableBeanFactory)registry, this.enableJustInTimeBinding);
        modules.add((Module)module);
        HashMap bindings = new HashMap();
        List<Object> elements = Elements.getElements((Stage)Stage.TOOL, modules);
        List errors = elements.stream().filter(e -> e instanceof Message).map(e -> (Message)e).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new ConfigurationException(errors);
        }
        if (((Boolean)this.applicationContext.getEnvironment().getProperty(SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME, Boolean.class, (Object)false)).booleanValue()) {
            elements = this.removeDuplicates(elements);
            modules = Collections.singletonList(Elements.getModule(elements));
        }
        if (this.applicationContext.getEnvironment().containsProperty("spring.guice.modules.exclude")) {
            String[] modulesToFilter = this.applicationContext.getEnvironment().getProperty("spring.guice.modules.exclude", "").split(",");
            elements = elements.stream().filter(e -> this.elementFilter(modulesToFilter, (Element)e)).collect(Collectors.toList());
            modules = Collections.singletonList(Elements.getModule(elements));
        }
        for (Element e2 : elements) {
            if (e2 instanceof Binding) {
                Binding binding = (Binding)e2;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e2 instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e2);
        }
        this.mapBindings(bindings, registry, module);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(GuiceInjectorInitializer.class);
        ArrayList<Module> finalModules = new ArrayList<Module>(modules);
        beanDefinition.setInstanceSupplier(() -> new GuiceInjectorInitializer(finalModules, (ConfigurableApplicationContext)this.applicationContext));
        beanDefinition.setAttribute("spring-guice", (Object)true);
        registry.registerBeanDefinition("guiceInjectorInitializer", (BeanDefinition)beanDefinition);
    }

    private List<Module> filterModules(BeanDefinitionRegistry registry, List<Module> modules) {
        Map moduleFilters = ((ConfigurableListableBeanFactory)registry).getBeansOfType(ModuleFilter.class);
        Predicate<Module> moduleFilter = m -> true;
        for (Predicate value : moduleFilters.values()) {
            moduleFilter = moduleFilter.and(value);
        }
        return modules.stream().filter(moduleFilter).collect(Collectors.toList());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
    }

    private void mapBindings(Map<Key<?>, Binding<?>> bindings, BeanDefinitionRegistry registry, SpringModule module) {
        Stage stage = (Stage)this.applicationContext.getEnvironment().getProperty(SPRING_GUICE_STAGE_PROPERTY_NAME, Stage.class, (Object)Stage.PRODUCTION);
        boolean ifLazyInit = stage.equals((Object)Stage.DEVELOPMENT);
        Map<Key, List<LinkedKeyBinding>> linkedBindingsByKey = bindings.values().stream().filter(e -> e instanceof LinkedKeyBinding).map(e -> (LinkedKeyBinding)e).collect(Collectors.groupingBy(LinkedKeyBinding::getLinkedKey));
        Map<Key, Binding> guiceBindingsByKey = bindings.entrySet().stream().filter(entry -> {
            Binding binding = (Binding)entry.getValue();
            Key key = (Key)entry.getKey();
            Object source = binding.getSource();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            Class annotationType = key.getAnnotationType();
            if (binding instanceof UntargettedBinding && linkedBindingsByKey.containsKey(binding.getKey())) {
                return false;
            }
            if (typeLiteral.getRawType().equals(Injector.class) || "spring-guice".equals(Optional.ofNullable(source).map(Object::toString).orElse(""))) {
                return false;
            }
            return annotationType == null || !SPRING_GUICE_IGNORED_ANNOTATION_PREFIXES.stream().anyMatch(prefix -> annotationType.getName().startsWith((String)prefix));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<Key, Binding> entry2 : guiceBindingsByKey.entrySet()) {
            Object source;
            Binding binding = entry2.getValue();
            Key key = entry2.getKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            Class annotationType = key.getAnnotationType();
            RootBeanDefinition bean = new RootBeanDefinition(GuiceFactoryBean.class);
            bean.setInstanceSupplier(() -> {
                GuiceFactoryBean factory = new GuiceFactoryBean(typeLiteral.getRawType(), key, Scopes.isSingleton((Binding)binding), module.getInjector());
                return factory;
            });
            bean.setTargetType(ResolvableType.forType((Type)typeLiteral.getType()));
            if (!Scopes.isSingleton((Binding)binding)) {
                bean.setScope("prototype");
            }
            if ((source = binding.getSource()) instanceof ElementSource) {
                bean.setResourceDescription(((ElementSource)source).getDeclaringSource().toString());
            } else {
                bean.setResourceDescription("spring-guice");
            }
            bean.setAttribute("spring-guice", (Object)true);
            if (annotationType != null) {
                String nameValue = this.getValueAttributeForNamed(key);
                bean.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)nameValue));
                bean.addQualifier(new AutowireCandidateQualifier(annotationType, (Object)nameValue));
            }
            if (ifLazyInit) {
                bean.setLazyInit(true);
            }
            registry.registerBeanDefinition(this.extractName(key), (BeanDefinition)bean);
        }
    }

    private String extractName(Key<?> key) {
        String className = key.getTypeLiteral().getType().getTypeName();
        String valueAttribute = this.getValueAttributeForNamed(key);
        if (valueAttribute != null) {
            return valueAttribute + "_" + className;
        }
        return className;
    }

    private String getValueAttributeForNamed(Key<?> key) {
        if (key.getAnnotation() instanceof Named) {
            return ((Named)key.getAnnotation()).value();
        }
        if (key.getAnnotation() instanceof javax.inject.Named) {
            return ((javax.inject.Named)key.getAnnotation()).value();
        }
        if (key.getAnnotationType() != null) {
            String annotationString;
            String wrappedNamedValue;
            String value = key.getAnnotationType().getName();
            if (key.getAnnotation() != null && (wrappedNamedValue = ModuleRegistryConfiguration.substringBetween(annotationString = key.getAnnotation().toString(), "@com.google.inject.name.Named(\"", "\")")) != null) {
                value = wrappedNamedValue + "_" + value;
            }
            return value;
        }
        return null;
    }

    private boolean elementFilter(String[] modulesToFilter, Element element) {
        try {
            return Arrays.stream(modulesToFilter).noneMatch(ex -> Optional.of(element).map(Element::getSource).map(Object::toString).orElse("").contains((CharSequence)ex));
        }
        catch (Exception ex2) {
            this.logger.error((Object)String.format("Unable fo filter element[%s] with filter [%s]", element, Arrays.toString(modulesToFilter)), (Throwable)ex2);
            return false;
        }
    }

    private void extractPrivateElements(Map<Key<?>, Binding<?>> bindings, PrivateElements privateElements) {
        List elements = privateElements.getElements();
        for (Element e : elements) {
            if (e instanceof Binding && privateElements.getExposedKeys().contains(((Binding)e).getKey())) {
                Binding binding = (Binding)e;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e);
        }
    }

    protected List<Element> removeDuplicates(List<Element> elements) {
        Predicate<Element> hasSpringSource = element -> element.getSource() != null && element.getSource().toString().contains("spring-guice");
        List bindings = elements.stream().filter(e -> e instanceof Binding).map(e -> (Binding)e).collect(Collectors.toList());
        Map<Key, Key> injectionKeys = bindings.stream().collect(Collectors.groupingBy(Binding::getKey)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Binding binding;
            List keyBindings = (List)e.getValue();
            if (keyBindings.size() == 1 && (binding = (Binding)keyBindings.get(0)) instanceof LinkedKeyBinding) {
                return ((LinkedKeyBinding)binding).getLinkedKey();
            }
            return (Key)e.getKey();
        }));
        Map<Key, List> duplicateBindings = bindings.stream().collect(Collectors.groupingBy(e -> (Key)injectionKeys.get(e.getKey()))).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1 && ((List)e.getValue()).stream().anyMatch(hasSpringSource)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return elements.stream().flatMap(e -> {
            Binding b;
            Key key;
            List duplicates;
            if (e instanceof Binding && (duplicates = (List)duplicateBindings.get(key = (Key)injectionKeys.get((b = (Binding)e).getKey()))) != null) {
                if (hasSpringSource.test((Element)b)) {
                    return duplicates.stream().filter(hasSpringSource.negate()).map(guiceBinding -> this.withKey(b, guiceBinding.getKey()));
                }
                return Stream.empty();
            }
            return Stream.of(e);
        }).collect(Collectors.toList());
    }

    private Binding<?> withKey(Binding<?> binding, Key<?> key) {
        try {
            return (BindingImpl)GUICE_BINDINGIMPL_WITHKEY.invoke(binding, key);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    static {
        try {
            GUICE_BINDINGIMPL_WITHKEY = BindingImpl.class.getDeclaredMethod("withKey", Key.class);
            GUICE_BINDINGIMPL_WITHKEY.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class GuiceInjectorInitializer
    implements BeanPostProcessor,
    ApplicationListener<CreateInjectorEvent> {
        private final AtomicBoolean injectorCreated = new AtomicBoolean(false);
        private final List<Module> modules;
        private final ConfigurableApplicationContext applicationContext;

        GuiceInjectorInitializer(List<Module> modules, ConfigurableApplicationContext applicationContext) {
            this.modules = modules;
            this.applicationContext = applicationContext;
            applicationContext.publishEvent((ApplicationEvent)new CreateInjectorEvent());
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (this.injectorCreated.compareAndSet(false, true)) {
                this.createInjector();
            }
            return bean;
        }

        public void onApplicationEvent(CreateInjectorEvent event) {
            if (this.injectorCreated.compareAndSet(false, true)) {
                this.createInjector();
            }
        }

        private void createInjector() {
            Injector injector = null;
            try {
                Map beansOfType = this.applicationContext.getBeansOfType(InjectorFactory.class);
                if (beansOfType.size() > 1) {
                    throw new ApplicationContextException("Found multiple beans of type " + InjectorFactory.class.getName() + "  Please ensure that only one InjectorFactory bean is defined. InjectorFactory beans found: " + beansOfType.keySet());
                }
                if (beansOfType.size() == 1) {
                    InjectorFactory injectorFactory = (InjectorFactory)beansOfType.values().iterator().next();
                    injector = injectorFactory.createInjector(this.modules);
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (injector == null) {
                injector = Guice.createInjector(this.modules);
            }
            this.applicationContext.getBeanFactory().registerResolvableDependency(Injector.class, (Object)injector);
            this.applicationContext.getBeanFactory().registerSingleton("injector", (Object)injector);
        }

        static class CreateInjectorEvent
        extends ApplicationEvent {
            private static final long serialVersionUID = -6546970378679850504L;

            CreateInjectorEvent() {
                super((Object)-6546970378679850504L);
            }
        }
    }
}

