/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Injector;
import com.google.inject.Key;
import javax.inject.Provider;
import org.springframework.beans.factory.FactoryBean;

class GuiceFactoryBean<T>
implements FactoryBean<T> {
    private final Key<T> key;
    private final Class<T> beanType;
    private final boolean isSingleton;
    private final Provider<Injector> injector;

    GuiceFactoryBean(Class<T> beanType, Key<T> key, boolean isSingleton, Provider<Injector> injector) {
        this.beanType = beanType;
        this.key = key;
        this.isSingleton = isSingleton;
        this.injector = injector;
    }

    public T getObject() throws Exception {
        return (T)((Injector)this.injector.get()).getInstance(this.key);
    }

    public Class<?> getObjectType() {
        return this.beanType;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }
}

