/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.injector;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.spi.Element;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.TypeConverterBinding;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

public class SpringInjector
implements Injector {
    private Injector injector;
    private DefaultListableBeanFactory beanFactory;

    public SpringInjector(ApplicationContext context) {
        this.beanFactory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        if (context.getBeanNamesForType(Injector.class, true, false).length > 0) {
            this.injector = (Injector)context.getBean(Injector.class);
        }
    }

    public void injectMembers(Object instance) {
        this.beanFactory.autowireBean(instance);
    }

    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return new MembersInjector<T>(){

            public void injectMembers(T instance) {
                SpringInjector.this.beanFactory.autowireBean(instance);
            }
        };
    }

    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }

    public Map<Key<?>, Binding<?>> getBindings() {
        return null;
    }

    public Map<Key<?>, Binding<?>> getAllBindings() {
        return null;
    }

    public <T> Binding<T> getBinding(Key<T> key) {
        return null;
    }

    public <T> Binding<T> getBinding(Class<T> type) {
        return null;
    }

    public <T> Binding<T> getExistingBinding(Key<T> key) {
        return null;
    }

    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return null;
    }

    public <T> Provider<T> getProvider(final Key<T> key) {
        final Class type = key.getTypeLiteral().getRawType();
        final String name = this.extractName(key);
        if (this.beanFactory.getBeanNamesForType(type, true, false).length == 0) {
            if (this.injector != null) {
                return this.injector.getProvider(key);
            }
            this.beanFactory.registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(type));
        }
        if (this.beanFactory.containsBean(name) && this.beanFactory.isTypeMatch(name, type)) {
            return new Provider<T>(){

                public T get() {
                    return SpringInjector.this.beanFactory.getBean(name);
                }
            };
        }
        final Class cls = type;
        return new Provider<T>(){

            public T get() {
                if (key.getAnnotation() != null) {
                    return BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)SpringInjector.this.beanFactory, (Class)type, (String)name);
                }
                return SpringInjector.this.beanFactory.getBean(cls);
            }
        };
    }

    private String extractName(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        if (annotation instanceof Named) {
            return ((Named)annotation).value();
        }
        if (annotation instanceof javax.inject.Named) {
            return ((javax.inject.Named)annotation).value();
        }
        return key.getTypeLiteral().getRawType().getSimpleName();
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.getProvider(key).get();
    }

    public <T> T getInstance(Class<T> type) {
        return this.getInstance(Key.get(type));
    }

    public Injector getParent() {
        return null;
    }

    public Injector createChildInjector(Iterable<? extends Module> modules) {
        return null;
    }

    public Injector createChildInjector(Module ... modules) {
        return null;
    }

    public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
        return null;
    }

    public Set<TypeConverterBinding> getTypeConverterBindings() {
        return null;
    }

    public List<Element> getElements() {
        return null;
    }

    public Map<TypeLiteral<?>, List<InjectionPoint>> getAllMembersInjectorInjectionPoints() {
        return null;
    }
}

