/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Injector;
import com.google.inject.Key;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

class GuiceFactoryBean<T>
implements FactoryBean<T> {
    private final Key<T> key;
    private final Class<T> beanType;
    private final boolean isSingleton;
    @Autowired
    private Injector injector;

    GuiceFactoryBean(Class<T> beanType, Key<T> key, boolean isSingleton) {
        this.beanType = beanType;
        this.key = key;
        this.isSingleton = isSingleton;
    }

    public T getObject() throws Exception {
        return (T)this.injector.getInstance(this.key);
    }

    public Class<?> getObjectType() {
        return this.beanType;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }
}

