/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

class JsonPointerMapping {
    private final BiFunction<String, Class<?>, Optional<String>> reader;
    private final BiFunction<String, Class<?>, Optional<String>> writer;

    public JsonPointerMapping(BindContext context) {
        this.reader = context::getReadableProperty;
        this.writer = context::getWritableProperty;
    }

    public JsonPointerMapping(BiFunction<String, Class<?>, Optional<String>> reader, BiFunction<String, Class<?>, Optional<String>> writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public String forRead(String pointer, Class<?> type) {
        return this.verify(pointer, type, this.reader, "readable");
    }

    public String forWrite(String pointer, Class<?> type) {
        return this.verify(pointer, type, this.writer, "writable");
    }

    private String verify(String pointer, Class<?> type, BiFunction<String, Class<?>, Optional<String>> filter, String qualifier) {
        String[] strings = pointer.split("/");
        if (strings.length == 0) {
            return pointer;
        }
        PropertyPath base = null;
        StringBuilder result = new StringBuilder();
        ClassTypeInformation currentType = ClassTypeInformation.from(type);
        for (int i = 0; i < strings.length; ++i) {
            String segment = strings[i];
            if (!StringUtils.hasText((String)segment)) continue;
            if (currentType != null && currentType.isMap()) {
                result.append("/").append(segment);
                currentType = currentType.getActualType();
                continue;
            }
            if (segment.equals("-") || segment.matches("\\d+")) {
                result.append("/").append(segment);
                currentType = currentType.getActualType();
                continue;
            }
            ClassTypeInformation rejectType = currentType;
            String property = (i == strings.length - 1 ? filter : this.reader).apply(segment, currentType.getType()).orElseThrow(() -> JsonPointerMapping.lambda$verify$0(segment, (TypeInformation)rejectType, pointer, qualifier));
            try {
                base = base == null ? PropertyPath.from((String)property, type) : base.nested(segment);
            }
            catch (PropertyReferenceException o_O) {
                throw JsonPointerMapping.reject(segment, rejectType, pointer, qualifier);
            }
            currentType = base.getTypeInformation();
            result.append("/").append(property);
        }
        return result.toString();
    }

    private static PatchException reject(String segment, TypeInformation<?> type, String pointer, String qualifier) {
        return new PatchException(String.format("Couldn't find %s property for pointer segment %s on %s in %s", qualifier, segment, type.getType(), pointer));
    }

    private static /* synthetic */ PatchException lambda$verify$0(String segment, TypeInformation rejectType, String pointer, String qualifier) {
        return JsonPointerMapping.reject(segment, rejectType, pointer, qualifier);
    }
}

