/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;

class DefaultZSetOperations<K, V>
extends AbstractOperations<K, V>
implements ZSetOperations<K, V> {
    DefaultZSetOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Boolean add(K key, V value, double score) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zAdd(rawKey, score, rawValue), true);
    }

    @Override
    public Long add(K key, Set<ZSetOperations.TypedTuple<V>> tuples) {
        byte[] rawKey = this.rawKey(key);
        Set<RedisZSetCommands.Tuple> rawValues = this.rawTupleValues(tuples);
        return this.execute(connection -> connection.zAdd(rawKey, rawValues), true);
    }

    @Override
    public Double incrementScore(K key, V value, double delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zIncrBy(rawKey, delta, rawValue), true);
    }

    @Override
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zInterStore(rawDestKey, rawKeys), true);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zInterStore(rawDestKey, aggregate, weights, rawKeys), true);
    }

    @Override
    public Set<V> range(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRange(rawKey, start, end), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRange(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRange(rawKey, start, end), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeWithScores(rawKey, start, end), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeWithScores(rawKey, start, end), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<V> rangeByLex(K key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByLex(rawKey, range, limit), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByLex(K key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByLex(rawKey, range, limit), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> rangeByScore(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScore(rawKey, min, max), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> rangeByScore(K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScore(rawKey, min, max, offset, count), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScore(rawKey, min, max), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScore(rawKey, min, max, offset, count), true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScoreWithScores(rawKey, min, max), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScoreWithScores(rawKey, min, max, offset, count), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScoreWithScores(rawKey, min, max), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScoreWithScores(rawKey, min, max, offset, count), true);
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Long rank(K key, Object o) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(o);
        return this.execute(connection -> {
            Long zRank = connection.zRank(rawKey, rawValue);
            return zRank != null && zRank >= 0L ? zRank : null;
        }, true);
    }

    @Override
    public Long reverseRank(K key, Object o) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(o);
        return this.execute(connection -> {
            Long zRank = connection.zRevRank(rawKey, rawValue);
            return zRank != null && zRank >= 0L ? zRank : null;
        }, true);
    }

    @Override
    public Long remove(K key, Object ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.zRem(rawKey, rawValues), true);
    }

    @Override
    public Long removeRange(K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRemRange(rawKey, start, end), true);
    }

    @Override
    public Long removeRangeByScore(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRemRangeByScore(rawKey, min, max), true);
    }

    @Override
    public Double score(K key, Object o) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(o);
        return this.execute(connection -> connection.zScore(rawKey, rawValue), true);
    }

    @Override
    public Long count(K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zCount(rawKey, min, max), true);
    }

    @Override
    public Long lexCount(K key, RedisZSetCommands.Range range) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zLexCount(rawKey, range), true);
    }

    @Override
    public Long size(K key) {
        return this.zCard(key);
    }

    @Override
    public Long zCard(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zCard(rawKey), true);
    }

    @Override
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zUnionStore(rawDestKey, rawKeys), true);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zUnionStore(rawDestKey, aggregate, weights, rawKeys), true);
    }

    @Override
    public Cursor<ZSetOperations.TypedTuple<V>> scan(K key, ScanOptions options) {
        byte[] rawKey = this.rawKey(key);
        Cursor cursor = this.template.executeWithStickyConnection(connection -> connection.zScan(rawKey, options));
        return new ConvertingCursor(cursor, this::deserializeTuple);
    }

    public Set<byte[]> rangeByScore(K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRangeByScore(rawKey, min, max), true);
    }

    public Set<byte[]> rangeByScore(K key, String min, String max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRangeByScore(rawKey, min, max, offset, count), true);
    }
}

