/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Range;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanStream;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveZSetCommands
implements ReactiveZSetCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveZSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty(command.getTuples(), (String)"Tuples must not be empty or null!");
            ZAddArgs args = null;
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isIncr()) {
                    if (command.getTuples().size() > 1) {
                        throw new IllegalArgumentException("ZADD INCR must not contain more than one tuple!");
                    }
                    RedisZSetCommands.Tuple tuple2 = command.getTuples().iterator().next();
                    return cmd.zaddincr((Object)command.getKey(), tuple2.getScore().doubleValue(), (Object)ByteBuffer.wrap(tuple2.getValue())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Double>((ReactiveZSetCommands.ZAddCommand)command, (Double)value));
                }
                if (command.isReturnTotalChanged()) {
                    args = ZAddArgs.Builder.ch();
                }
                args = command.isUpsert() ? ZAddArgs.Builder.nx() : ZAddArgs.Builder.xx();
            }
            ScoredValue[] values = (ScoredValue[])command.getTuples().stream().map(tuple -> ScoredValue.fromNullable((double)tuple.getScore(), (Object)ByteBuffer.wrap(tuple.getValue()))).toArray(ScoredValue[]::new);
            Mono result = args == null ? cmd.zadd((Object)command.getKey(), values) : cmd.zadd((Object)command.getKey(), args, values);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Long>((ReactiveZSetCommands.ZAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty(command.getValues(), (String)"Values must not be null or empty!");
            return cmd.zrem((Object)command.getKey(), (Object[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>((ReactiveZSetCommands.ZRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            Assert.notNull((Object)command.getIncrement(), (String)"Increment value must not be null!");
            return cmd.zincrby((Object)command.getKey(), command.getIncrement().doubleValue(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>((ReactiveZSetCommands.ZIncrByCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Mono result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrank((Object)command.getKey(), (Object)command.getValue()) : cmd.zrevrank((Object)command.getKey(), (Object)command.getValue());
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>((ReactiveZSetCommands.ZRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            long start = LettuceConverters.getLowerBoundIndex(command.getRange());
            long stop = LettuceConverters.getUpperBoundIndex(command.getRange());
            Flux result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? (command.isWithScores() ? cmd.zrangeWithScores((Object)command.getKey(), start, stop).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes((ScoredValue<ByteBuffer>)sc), sc.getScore())) : cmd.zrange((Object)command.getKey(), start, stop).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN))) : (command.isWithScores() ? cmd.zrevrangeWithScores((Object)command.getKey(), start, stop).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes((ScoredValue<ByteBuffer>)sc), sc.getScore())) : cmd.zrevrange((Object)command.getKey(), start, stop).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux>((ReactiveZSetCommands.ZRangeCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Flux result;
            boolean isLimited;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            boolean bl = isLimited = command.getLimit().isPresent() && !command.getLimit().get().isUnlimited();
            if (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC)) {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrangebyscoreWithScores((Object)command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())) : cmd.zrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore()))) : (!isLimited ? cmd.zrangebyscore((Object)command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)) : cmd.zrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            } else {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrevrangebyscoreWithScores((Object)command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())) : cmd.zrevrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore()))) : (!isLimited ? cmd.zrevrangebyscore((Object)command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)) : cmd.zrevrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux>((ReactiveZSetCommands.ZRangeByScoreCommand)command, Flux.from((Publisher)result)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null!");
            Flux result = ScanStream.zscan((RedisSortedSetReactiveCommands)cmd, (Object)command.getKey(), (ScanArgs)LettuceConverters.toScanArgs(command.getOptions())).map(it -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)it.getValue()), it.getScore()));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux>((ReactiveRedisConnection.KeyScanCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Range range = RangeConverter.toRange(command.getRange());
            Mono result = cmd.zcount((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>((ReactiveZSetCommands.ZCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>> zLexCount(Publisher<ReactiveZSetCommands.ZLexCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Mono result = cmd.zlexcount((Object)command.getKey(), RangeConverter.toRange(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>((ReactiveZSetCommands.ZLexCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.zcard((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.zscore((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>((ReactiveZSetCommands.ZScoreCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Mono result = cmd.zremrangebyrank((Object)command.getKey(), LettuceConverters.getLowerBoundIndex(command.getRange()), LettuceConverters.getUpperBoundIndex(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>((ReactiveZSetCommands.ZRemRangeByRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Range range = RangeConverter.toRange(command.getRange());
            Mono result = cmd.zremrangebyscore((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>((ReactiveZSetCommands.ZRemRangeByScoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>> zUnionStore(Publisher<ReactiveZSetCommands.ZUnionStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono result = args != null ? cmd.zunionstore((Object)command.getKey(), args, sourceKeys) : cmd.zunionstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>((ReactiveZSetCommands.ZUnionStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>> zInterStore(Publisher<ReactiveZSetCommands.ZInterStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono result = args != null ? cmd.zinterstore((Object)command.getKey(), args, sourceKeys) : cmd.zinterstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>((ReactiveZSetCommands.ZInterStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Flux result = !command.getLimit().isUnlimited() ? (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit())) : cmd.zrevrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit()))) : (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange())) : cmd.zrevrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange())));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux>((ReactiveZSetCommands.ZRangeByLexCommand)command, result));
        }));
    }

    private static ZStoreArgs zStoreArgs(@Nullable RedisZSetCommands.Aggregate aggregate, @Nullable List<Double> weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        if (weights != null) {
            args.weights(weights.stream().mapToDouble(it -> it).toArray());
        }
        return args;
    }

    private static byte[] getBytes(ScoredValue<ByteBuffer> scoredValue) {
        return scoredValue.optional().map(ByteUtils::getBytes).orElse(new byte[0]);
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

