/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.config.Neo4jRepositoryConfigurationExtension;
import org.springframework.data.neo4j.repository.query.AbstractGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.CustomResultConverter;
import org.springframework.data.neo4j.repository.query.GraphParameters;
import org.springframework.data.neo4j.repository.query.GraphParametersParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.spel.ParameterizedQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class GraphRepositoryQuery
extends AbstractGraphRepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(GraphRepositoryQuery.class);
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private ParameterizedQuery parameterizedQuery;
    private final Optional<Constructor<?>> singleUseEntityMapperUsingInstantiator;
    private final Object entityInstantiator;

    GraphRepositoryQuery(GraphQueryMethod graphQueryMethod, MetaData metaData, Session session, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(graphQueryMethod, metaData, session);
        this.evaluationContextProvider = evaluationContextProvider;
        if (Neo4jRepositoryConfigurationExtension.HAS_ENTITY_INSTANTIATOR_FEATURE) {
            this.entityInstantiator = GraphRepositoryQuery.getEntityInstantiator(metaData, this.queryMethod.getMappingContext());
            this.singleUseEntityMapperUsingInstantiator = ReflectionUtils.findConstructor(SingleUseEntityMapper.class, (Object[])new Object[]{metaData, this.entityInstantiator});
        } else {
            this.entityInstantiator = null;
            this.singleUseEntityMapperUsingInstantiator = Optional.empty();
        }
    }

    @Override
    protected Object doExecute(Query query, Object[] parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing query for method {}", (Object)this.queryMethod.getName());
        }
        GraphParametersParameterAccessor accessor = new GraphParametersParameterAccessor(this.queryMethod, parameters);
        Class<?> returnType = this.queryMethod.getMethod().getReturnType();
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Object result = this.getExecution(accessor).execute(query, processor.getReturnedType().getReturnedType());
        return Result.class.equals(returnType) ? result : processor.processResult(result, (Converter)new CustomResultConverter(this.metaData, processor.getReturnedType().getReturnedType(), this.singleUseEntityMapperUsingInstantiator, this.entityInstantiator));
    }

    @Override
    protected Query getQuery(Object[] parameters) {
        ParameterizedQuery parameterizedQuery = this.getParameterizedQuery();
        Map<String, Object> parametersFromQuery = parameterizedQuery.resolveParameter(parameters, this::resolveParams);
        return new Query(parameterizedQuery.getQueryString(), this.queryMethod.getCountQueryString(), parametersFromQuery);
    }

    private ParameterizedQuery getParameterizedQuery() {
        if (this.parameterizedQuery == null) {
            GraphParameters methodParameters = this.queryMethod.getParameters();
            this.parameterizedQuery = ParameterizedQuery.getParameterizedQuery(this.getAnnotationQueryString(), methodParameters, this.evaluationContextProvider);
        }
        return this.parameterizedQuery;
    }

    Map<String, Object> resolveParams(Parameters<?, ?> methodParameters, Object[] parameters) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (Parameter parameter : methodParameters) {
            int parameterIndex = parameter.getIndex();
            Object parameterValue = this.getParameterValue(parameters[parameterIndex]);
            resolvedParameters.put(Integer.toString(parameterIndex), parameterValue);
            if (!parameter.isNamedParameter()) continue;
            parameter.getName().ifPresent(parameterName -> resolvedParameters.put((String)parameterName, parameterValue));
        }
        return resolvedParameters;
    }

    private String getAnnotationQueryString() {
        return this.getQueryMethod().getQuery();
    }

    private Object getParameterValue(Object parameter) {
        Object parameterValue = this.session.resolveGraphIdFor(parameter);
        if (parameterValue == null) {
            parameterValue = parameter;
        }
        return parameterValue;
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    private static Object getEntityInstantiator(MetaData metaData, @Nullable MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext) {
        try {
            Class<?> queryResultInstantiatorClass = Class.forName("org.springframework.data.neo4j.repository.query.QueryResultInstantiator", true, ClassUtils.getDefaultClassLoader());
            Optional queryResultInstantiatorConstructor = ReflectionUtils.findConstructor(queryResultInstantiatorClass, (Object[])new Object[]{metaData, mappingContext});
            return queryResultInstantiatorConstructor.map(ctor -> BeanUtils.instantiateClass((Constructor)ctor, (Object[])new Object[]{metaData, mappingContext})).get();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

