/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TypedJsonSchemaObject
extends UntypedJsonSchemaObject {
    protected final Set<JsonSchemaObject.Type> types;

    TypedJsonSchemaObject(@Nullable JsonSchemaObject.Type type, @Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
        this(type != null ? Collections.singleton(type) : Collections.emptySet(), description, generateDescription, restrictions);
    }

    TypedJsonSchemaObject(Set<JsonSchemaObject.Type> types, @Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
        super(restrictions, description, generateDescription);
        Assert.notNull(types, (String)"Types must not be null! Please consider using 'Collections.emptySet()'.");
        this.types = types;
    }

    public static TypedJsonSchemaObject of(JsonSchemaObject.Type ... types) {
        Assert.notNull((Object)types, (String)"Types must not be null!");
        Assert.noNullElements((Object[])types, (String)"Types must not contain null!");
        return new TypedJsonSchemaObject(new LinkedHashSet<JsonSchemaObject.Type>(Arrays.asList(types)), null, false, UntypedJsonSchemaObject.Restrictions.empty());
    }

    @Override
    public Set<JsonSchemaObject.Type> getTypes() {
        return this.types;
    }

    @Override
    public TypedJsonSchemaObject description(String description) {
        return new TypedJsonSchemaObject(this.types, description, this.generateDescription, this.restrictions);
    }

    @Override
    public TypedJsonSchemaObject generatedDescription() {
        return new TypedJsonSchemaObject(this.types, this.description, true, this.restrictions);
    }

    @Override
    public TypedJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
        return new TypedJsonSchemaObject(this.types, this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
    }

    @Override
    public TypedJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
        return new TypedJsonSchemaObject(this.types, this.description, this.generateDescription, this.restrictions.allOf(allOf));
    }

    @Override
    public TypedJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
        return new TypedJsonSchemaObject(this.types, this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
    }

    @Override
    public TypedJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
        return new TypedJsonSchemaObject(this.types, this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
    }

    @Override
    public TypedJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
        return new TypedJsonSchemaObject(this.types, this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
    }

    @Override
    public Document toDocument() {
        Document document = new Document();
        if (!CollectionUtils.isEmpty(this.types)) {
            JsonSchemaObject.Type theType = this.types.iterator().next();
            if (this.types.size() == 1) {
                document.append(theType.representation(), theType.value());
            } else {
                document.append(theType.representation(), this.types.stream().map(JsonSchemaObject.Type::value).collect(Collectors.toList()));
            }
        }
        this.getOrCreateDescription().ifPresent(val -> document.append("description", val));
        document.putAll((Map)this.restrictions.toDocument());
        return document;
    }

    private Optional<String> getOrCreateDescription() {
        if (this.description != null) {
            return this.description.isEmpty() ? Optional.empty() : Optional.of(this.description);
        }
        return this.generateDescription ? Optional.ofNullable(this.generateDescription()) : Optional.empty();
    }

    @Override
    @Nullable
    protected String generateDescription() {
        return null;
    }

    static class TimestampJsonSchemaObject
    extends TypedJsonSchemaObject {
        TimestampJsonSchemaObject() {
            this(null, false, null);
        }

        private TimestampJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.timestampType(), description, generateDescription, restrictions);
        }

        @Override
        public TimestampJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return new TimestampJsonSchemaObject(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public TimestampJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return new TimestampJsonSchemaObject(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public TimestampJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return new TimestampJsonSchemaObject(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public TimestampJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return new TimestampJsonSchemaObject(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public TimestampJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return new TimestampJsonSchemaObject(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public TimestampJsonSchemaObject description(String description) {
            return new TimestampJsonSchemaObject(description, this.generateDescription, this.restrictions);
        }

        @Override
        public TimestampJsonSchemaObject generatedDescription() {
            return new TimestampJsonSchemaObject(this.description, true, this.restrictions);
        }

        @Override
        protected String generateDescription() {
            return "Must be a timestamp.";
        }
    }

    static class DateJsonSchemaObject
    extends TypedJsonSchemaObject {
        DateJsonSchemaObject() {
            this(null, false, null);
        }

        private DateJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.dateType(), description, generateDescription, restrictions);
        }

        @Override
        public DateJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return new DateJsonSchemaObject(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public DateJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return new DateJsonSchemaObject(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public DateJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return new DateJsonSchemaObject(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public DateJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return new DateJsonSchemaObject(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public DateJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return new DateJsonSchemaObject(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public DateJsonSchemaObject description(String description) {
            return new DateJsonSchemaObject(description, this.generateDescription, this.restrictions);
        }

        @Override
        public DateJsonSchemaObject generatedDescription() {
            return new DateJsonSchemaObject(this.description, true, this.restrictions);
        }

        @Override
        protected String generateDescription() {
            return "Must be a date.";
        }
    }

    static class NullJsonSchemaObject
    extends TypedJsonSchemaObject {
        NullJsonSchemaObject() {
            this(null, false, null);
        }

        private NullJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.nullType(), description, generateDescription, restrictions);
        }

        @Override
        public NullJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return new NullJsonSchemaObject(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public NullJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return new NullJsonSchemaObject(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public NullJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return new NullJsonSchemaObject(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public NullJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return new NullJsonSchemaObject(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public NullJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return new NullJsonSchemaObject(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public NullJsonSchemaObject description(String description) {
            return new NullJsonSchemaObject(description, this.generateDescription, this.restrictions);
        }

        @Override
        public NullJsonSchemaObject generatedDescription() {
            return new NullJsonSchemaObject(this.description, true, this.restrictions);
        }

        @Override
        protected String generateDescription() {
            return "Must be null.";
        }
    }

    public static class BooleanJsonSchemaObject
    extends TypedJsonSchemaObject {
        BooleanJsonSchemaObject() {
            this(null, false, null);
        }

        private BooleanJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.booleanType(), description, generateDescription, restrictions);
        }

        @Override
        public BooleanJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return new BooleanJsonSchemaObject(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public BooleanJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return new BooleanJsonSchemaObject(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public BooleanJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return new BooleanJsonSchemaObject(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public BooleanJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return new BooleanJsonSchemaObject(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public BooleanJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return new BooleanJsonSchemaObject(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public BooleanJsonSchemaObject description(String description) {
            return new BooleanJsonSchemaObject(description, this.generateDescription, this.restrictions);
        }

        @Override
        public BooleanJsonSchemaObject generatedDescription() {
            return new BooleanJsonSchemaObject(this.description, true, this.restrictions);
        }

        @Override
        protected String generateDescription() {
            return "Must be a boolean.";
        }
    }

    public static class ArrayJsonSchemaObject
    extends TypedJsonSchemaObject {
        @Nullable
        private Boolean uniqueItems;
        @Nullable
        private Boolean additionalItems;
        @Nullable
        private Range<Integer> range;
        private Collection<JsonSchemaObject> items = Collections.emptyList();

        ArrayJsonSchemaObject() {
            this(null, false, null);
        }

        private ArrayJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(Collections.singleton(JsonSchemaObject.Type.arrayType()), description, generateDescription, restrictions);
        }

        public ArrayJsonSchemaObject uniqueItems(boolean uniqueItems) {
            ArrayJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.uniqueItems = uniqueItems;
            return newInstance;
        }

        public ArrayJsonSchemaObject range(Range<Integer> range) {
            ArrayJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.range = range;
            return newInstance;
        }

        public ArrayJsonSchemaObject minItems(int count) {
            Range.Bound upper = this.range != null ? this.range.getUpperBound() : Range.Bound.unbounded();
            return this.range((Range<Integer>)Range.of((Range.Bound)Range.Bound.inclusive((int)count), (Range.Bound)upper));
        }

        public ArrayJsonSchemaObject maxItems(int count) {
            Range.Bound lower = this.range != null ? this.range.getLowerBound() : Range.Bound.unbounded();
            return this.range((Range<Integer>)Range.of((Range.Bound)lower, (Range.Bound)Range.Bound.inclusive((int)count)));
        }

        public ArrayJsonSchemaObject items(Collection<JsonSchemaObject> items) {
            ArrayJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.items = new ArrayList<JsonSchemaObject>(items);
            return newInstance;
        }

        public ArrayJsonSchemaObject additionalItems(boolean additionalItemsAllowed) {
            ArrayJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.additionalItems = additionalItemsAllowed;
            return newInstance;
        }

        @Override
        public ArrayJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public ArrayJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public ArrayJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public ArrayJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public ArrayJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public ArrayJsonSchemaObject description(String description) {
            return this.newInstance(description, this.generateDescription, this.restrictions);
        }

        @Override
        public ArrayJsonSchemaObject generatedDescription() {
            return this.newInstance(this.description, true, this.restrictions);
        }

        @Override
        public Document toDocument() {
            Document doc = new Document((Map)super.toDocument());
            if (!CollectionUtils.isEmpty(this.items)) {
                doc.append("items", this.items.size() == 1 ? this.items.iterator().next().toDocument() : this.items.stream().map(JsonSchemaObject::toDocument).collect(Collectors.toList()));
            }
            if (this.range != null) {
                this.range.getLowerBound().getValue().ifPresent(it -> doc.append("minItems", it));
                this.range.getUpperBound().getValue().ifPresent(it -> doc.append("maxItems", it));
            }
            if (ObjectUtils.nullSafeEquals((Object)this.uniqueItems, (Object)Boolean.TRUE)) {
                doc.append("uniqueItems", (Object)true);
            }
            if (this.additionalItems != null) {
                doc.append("additionalItems", (Object)this.additionalItems);
            }
            return doc;
        }

        private ArrayJsonSchemaObject newInstance(@Nullable String description, boolean generateDescription, UntypedJsonSchemaObject.Restrictions restrictions) {
            ArrayJsonSchemaObject newInstance = new ArrayJsonSchemaObject(description, generateDescription, restrictions);
            newInstance.uniqueItems = this.uniqueItems;
            newInstance.range = this.range;
            newInstance.items = this.items;
            newInstance.additionalItems = this.additionalItems;
            return newInstance;
        }

        @Override
        protected String generateDescription() {
            String description = "Must be an array";
            if (ObjectUtils.nullSafeEquals((Object)this.uniqueItems, (Object)Boolean.TRUE)) {
                description = description + " of unique values";
            }
            if (ObjectUtils.nullSafeEquals((Object)this.additionalItems, (Object)Boolean.TRUE)) {
                description = description + " with additional items";
            }
            if (ObjectUtils.nullSafeEquals((Object)this.additionalItems, (Object)Boolean.FALSE)) {
                description = description + " with no additional items";
            }
            if (this.range != null) {
                description = description + String.format(" having size %s", this.range);
            }
            if (!ObjectUtils.isEmpty(this.items)) {
                description = description + String.format(" with items %s", StringUtils.collectionToDelimitedString((Collection)this.items.stream().map(JsonSchemaObject::toDocument).collect(Collectors.toList()), (String)", "));
            }
            return description + ".";
        }
    }

    public static class StringJsonSchemaObject
    extends TypedJsonSchemaObject {
        @Nullable
        Range<Integer> length;
        @Nullable
        String pattern;

        StringJsonSchemaObject() {
            this(null, false, null);
        }

        private StringJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.stringType(), description, generateDescription, restrictions);
        }

        public StringJsonSchemaObject length(Range<Integer> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            StringJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.length = range;
            return newInstance;
        }

        public StringJsonSchemaObject minLength(int length) {
            Range.Bound upper = this.length != null ? this.length.getUpperBound() : Range.Bound.unbounded();
            return this.length((Range<Integer>)Range.of((Range.Bound)Range.Bound.inclusive((int)length), (Range.Bound)upper));
        }

        public StringJsonSchemaObject maxLength(int length) {
            Range.Bound lower = this.length != null ? this.length.getLowerBound() : Range.Bound.unbounded();
            return this.length((Range<Integer>)Range.of((Range.Bound)lower, (Range.Bound)Range.Bound.inclusive((int)length)));
        }

        public StringJsonSchemaObject matching(String pattern) {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
            StringJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.pattern = pattern;
            return newInstance;
        }

        @Override
        public StringJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public StringJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public StringJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public StringJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public StringJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public StringJsonSchemaObject description(String description) {
            return this.newInstance(description, this.generateDescription, this.restrictions);
        }

        @Override
        public StringJsonSchemaObject generatedDescription() {
            return this.newInstance(this.description, true, this.restrictions);
        }

        @Override
        public Document toDocument() {
            Document doc = new Document((Map)super.toDocument());
            if (this.length != null) {
                this.length.getLowerBound().getValue().ifPresent(it -> doc.append("minLength", it));
                this.length.getUpperBound().getValue().ifPresent(it -> doc.append("maxLength", it));
            }
            if (!StringUtils.isEmpty((Object)this.pattern)) {
                doc.append("pattern", (Object)this.pattern);
            }
            return doc;
        }

        private StringJsonSchemaObject newInstance(@Nullable String description, boolean generateDescription, UntypedJsonSchemaObject.Restrictions restrictions) {
            StringJsonSchemaObject newInstance = new StringJsonSchemaObject(description, generateDescription, restrictions);
            newInstance.length = this.length;
            newInstance.pattern = this.pattern;
            return newInstance;
        }

        @Override
        protected String generateDescription() {
            String description = "Must be a string";
            if (this.length != null) {
                description = description + String.format(" with length %s", this.length);
            }
            if (this.pattern != null) {
                description = description + String.format(" matching %s", this.pattern);
            }
            return description + ".";
        }
    }

    public static class NumericJsonSchemaObject
    extends TypedJsonSchemaObject {
        private static final Set<JsonSchemaObject.Type> NUMERIC_TYPES = new HashSet<JsonSchemaObject.Type>(Arrays.asList(JsonSchemaObject.Type.doubleType(), JsonSchemaObject.Type.intType(), JsonSchemaObject.Type.longType(), JsonSchemaObject.Type.numberType(), JsonSchemaObject.Type.bigDecimalType()));
        @Nullable
        Number multipleOf;
        @Nullable
        Range<? extends Number> range;

        NumericJsonSchemaObject() {
            this(JsonSchemaObject.Type.numberType());
        }

        NumericJsonSchemaObject(JsonSchemaObject.Type type) {
            this(type, null, false);
        }

        private NumericJsonSchemaObject(JsonSchemaObject.Type type, @Nullable String description, boolean generateDescription) {
            this(Collections.singleton(type), description, generateDescription, null);
        }

        private NumericJsonSchemaObject(Set<JsonSchemaObject.Type> types, @Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(NumericJsonSchemaObject.validateTypes(types), description, generateDescription, restrictions);
        }

        NumericJsonSchemaObject multipleOf(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            NumericJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.multipleOf = value;
            return newInstance;
        }

        public NumericJsonSchemaObject within(Range<? extends Number> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            NumericJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.range = range;
            return newInstance;
        }

        public NumericJsonSchemaObject gt(Number min) {
            Assert.notNull((Object)min, (String)"Min must not be null!");
            Range.Bound upper = this.range != null ? this.range.getUpperBound() : Range.Bound.unbounded();
            return this.within((Range<? extends Number>)Range.of(NumericJsonSchemaObject.createBound(min, false), (Range.Bound)upper));
        }

        public NumericJsonSchemaObject gte(Number min) {
            Assert.notNull((Object)min, (String)"Min must not be null!");
            Range.Bound upper = this.range != null ? this.range.getUpperBound() : Range.Bound.unbounded();
            return this.within((Range<? extends Number>)Range.of(NumericJsonSchemaObject.createBound(min, true), (Range.Bound)upper));
        }

        public NumericJsonSchemaObject lt(Number max) {
            Assert.notNull((Object)max, (String)"Max must not be null!");
            Range.Bound lower = this.range != null ? this.range.getLowerBound() : Range.Bound.unbounded();
            return this.within((Range<? extends Number>)Range.of((Range.Bound)lower, NumericJsonSchemaObject.createBound(max, false)));
        }

        NumericJsonSchemaObject lte(Number max) {
            Assert.notNull((Object)max, (String)"Max must not be null!");
            Range.Bound lower = this.range != null ? this.range.getLowerBound() : Range.Bound.unbounded();
            return this.within((Range<? extends Number>)Range.of((Range.Bound)lower, NumericJsonSchemaObject.createBound(max, true)));
        }

        @Override
        public NumericJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public NumericJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public NumericJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public NumericJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public NumericJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public NumericJsonSchemaObject description(String description) {
            return this.newInstance(description, this.generateDescription, this.restrictions);
        }

        @Override
        public NumericJsonSchemaObject generatedDescription() {
            return this.newInstance(this.description, true, this.restrictions);
        }

        @Override
        public Document toDocument() {
            Document doc = new Document((Map)super.toDocument());
            if (this.multipleOf != null) {
                doc.append("multipleOf", (Object)this.multipleOf);
            }
            if (this.range != null) {
                if (this.range.getLowerBound().isBounded()) {
                    this.range.getLowerBound().getValue().ifPresent(it -> doc.append("minimum", it));
                    if (!this.range.getLowerBound().isInclusive()) {
                        doc.append("exclusiveMinimum", (Object)true);
                    }
                }
                if (this.range.getUpperBound().isBounded()) {
                    this.range.getUpperBound().getValue().ifPresent(it -> doc.append("maximum", it));
                    if (!this.range.getUpperBound().isInclusive()) {
                        doc.append("exclusiveMaximum", (Object)true);
                    }
                }
            }
            return doc;
        }

        private NumericJsonSchemaObject newInstance(@Nullable String description, boolean generateDescription, UntypedJsonSchemaObject.Restrictions restrictions) {
            NumericJsonSchemaObject newInstance = new NumericJsonSchemaObject(this.types, description, generateDescription, restrictions);
            newInstance.multipleOf = this.multipleOf;
            newInstance.range = this.range;
            return newInstance;
        }

        private static Range.Bound<?> createBound(Number number, boolean inclusive) {
            if (number instanceof Long) {
                return inclusive ? Range.Bound.inclusive((Comparable)((Long)number)) : Range.Bound.exclusive((Comparable)((Long)number));
            }
            if (number instanceof Double) {
                return inclusive ? Range.Bound.inclusive((Comparable)((Double)number)) : Range.Bound.exclusive((Comparable)((Double)number));
            }
            if (number instanceof Float) {
                return inclusive ? Range.Bound.inclusive((Comparable)((Float)number)) : Range.Bound.exclusive((Comparable)((Float)number));
            }
            if (number instanceof Integer) {
                return inclusive ? Range.Bound.inclusive((Comparable)((Integer)number)) : Range.Bound.exclusive((Comparable)((Integer)number));
            }
            if (number instanceof BigDecimal) {
                return inclusive ? Range.Bound.inclusive((Comparable)((BigDecimal)number)) : Range.Bound.exclusive((Comparable)((BigDecimal)number));
            }
            throw new IllegalArgumentException("Unsupported numeric value.");
        }

        private static Set<JsonSchemaObject.Type> validateTypes(Set<JsonSchemaObject.Type> types) {
            types.forEach(type -> Assert.isTrue((boolean)NUMERIC_TYPES.contains(type), () -> String.format("%s is not a valid numeric type. Expected one of %s.", type, NUMERIC_TYPES)));
            return types;
        }

        @Override
        protected String generateDescription() {
            String description = "Must be a numeric value";
            if (this.multipleOf != null) {
                description = description + String.format(" multiple of %s", this.multipleOf);
            }
            if (this.range != null) {
                description = description + String.format(" within range %s", this.range);
            }
            return description + ".";
        }
    }

    public static class ObjectJsonSchemaObject
    extends TypedJsonSchemaObject {
        @Nullable
        private Range<Integer> propertiesCount;
        @Nullable
        private Object additionalProperties;
        private List<String> requiredProperties = Collections.emptyList();
        private List<JsonSchemaProperty> properties = Collections.emptyList();
        private List<JsonSchemaProperty> patternProperties = Collections.emptyList();

        public ObjectJsonSchemaObject() {
            this(null, false, null);
        }

        ObjectJsonSchemaObject(@Nullable String description, boolean generateDescription, @Nullable UntypedJsonSchemaObject.Restrictions restrictions) {
            super(JsonSchemaObject.Type.objectType(), description, generateDescription, restrictions);
        }

        public ObjectJsonSchemaObject propertiesCount(Range<Integer> range) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.propertiesCount = range;
            return newInstance;
        }

        public ObjectJsonSchemaObject minProperties(int count) {
            Range.Bound upper = this.propertiesCount != null ? this.propertiesCount.getUpperBound() : Range.Bound.unbounded();
            return this.propertiesCount((Range<Integer>)Range.of((Range.Bound)Range.Bound.inclusive((int)count), (Range.Bound)upper));
        }

        public ObjectJsonSchemaObject maxProperties(int count) {
            Range.Bound lower = this.propertiesCount != null ? this.propertiesCount.getLowerBound() : Range.Bound.unbounded();
            return this.propertiesCount((Range<Integer>)Range.of((Range.Bound)lower, (Range.Bound)Range.Bound.inclusive((int)count)));
        }

        public ObjectJsonSchemaObject required(String ... properties) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.requiredProperties = new ArrayList<String>(this.requiredProperties.size() + properties.length);
            newInstance.requiredProperties.addAll(this.requiredProperties);
            newInstance.requiredProperties.addAll(Arrays.asList(properties));
            return newInstance;
        }

        public ObjectJsonSchemaObject additionalProperties(boolean additionalPropertiesAllowed) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.additionalProperties = additionalPropertiesAllowed;
            return newInstance;
        }

        public ObjectJsonSchemaObject additionalProperties(ObjectJsonSchemaObject schema) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.additionalProperties = schema;
            return newInstance;
        }

        public ObjectJsonSchemaObject properties(JsonSchemaProperty ... properties) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.properties = new ArrayList<JsonSchemaProperty>(this.properties.size() + properties.length);
            newInstance.properties.addAll(this.properties);
            newInstance.properties.addAll(Arrays.asList(properties));
            return newInstance;
        }

        public ObjectJsonSchemaObject patternProperties(JsonSchemaProperty ... regularExpressions) {
            ObjectJsonSchemaObject newInstance = this.newInstance(this.description, this.generateDescription, this.restrictions);
            newInstance.patternProperties = new ArrayList<JsonSchemaProperty>(this.patternProperties.size() + regularExpressions.length);
            newInstance.patternProperties.addAll(this.patternProperties);
            newInstance.patternProperties.addAll(Arrays.asList(regularExpressions));
            return newInstance;
        }

        public ObjectJsonSchemaObject property(JsonSchemaProperty property) {
            return this.properties(property);
        }

        @Override
        public ObjectJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.possibleValues(possibleValues));
        }

        @Override
        public ObjectJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.allOf(allOf));
        }

        @Override
        public ObjectJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.anyOf(anyOf));
        }

        @Override
        public ObjectJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.oneOf(oneOf));
        }

        @Override
        public ObjectJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
            return this.newInstance(this.description, this.generateDescription, this.restrictions.notMatch(notMatch));
        }

        @Override
        public ObjectJsonSchemaObject description(String description) {
            return this.newInstance(description, this.generateDescription, this.restrictions);
        }

        @Override
        public ObjectJsonSchemaObject generatedDescription() {
            return this.newInstance(this.description, true, this.restrictions);
        }

        public List<JsonSchemaProperty> getProperties() {
            return this.properties;
        }

        @Override
        public Document toDocument() {
            Document doc = new Document((Map)super.toDocument());
            Collection<String> allRequiredProperties = this.requiredProperties();
            if (!CollectionUtils.isEmpty(allRequiredProperties)) {
                doc.append("required", new ArrayList<String>(allRequiredProperties));
            }
            if (this.propertiesCount != null) {
                this.propertiesCount.getLowerBound().getValue().ifPresent(it -> doc.append("minProperties", it));
                this.propertiesCount.getUpperBound().getValue().ifPresent(it -> doc.append("maxProperties", it));
            }
            if (!CollectionUtils.isEmpty(this.properties)) {
                doc.append("properties", (Object)this.reduceToDocument(this.properties));
            }
            if (!CollectionUtils.isEmpty(this.patternProperties)) {
                doc.append("patternProperties", (Object)this.reduceToDocument(this.patternProperties));
            }
            if (this.additionalProperties != null) {
                doc.append("additionalProperties", this.additionalProperties instanceof JsonSchemaObject ? ((JsonSchemaObject)this.additionalProperties).toDocument() : this.additionalProperties);
            }
            return doc;
        }

        private Collection<String> requiredProperties() {
            LinkedHashSet<String> target = new LinkedHashSet<String>();
            target.addAll(this.requiredProperties);
            this.properties.stream().filter(JsonSchemaProperty::isRequired).forEach(it -> target.add(it.getIdentifier()));
            return target;
        }

        private ObjectJsonSchemaObject newInstance(@Nullable String description, boolean generateDescription, UntypedJsonSchemaObject.Restrictions restrictions) {
            ObjectJsonSchemaObject newInstance = new ObjectJsonSchemaObject(description, generateDescription, restrictions);
            newInstance.properties = this.properties;
            newInstance.requiredProperties = this.requiredProperties;
            newInstance.additionalProperties = this.additionalProperties;
            newInstance.propertiesCount = this.propertiesCount;
            newInstance.patternProperties = this.patternProperties;
            return newInstance;
        }

        private Document reduceToDocument(Collection<JsonSchemaProperty> source) {
            return source.stream().map(JsonSchemaObject::toDocument).collect(Document::new, Document::putAll, (target, propertyDocument) -> {});
        }

        @Override
        protected String generateDescription() {
            String description = "Must be an object";
            if (this.propertiesCount != null) {
                description = description + String.format(" with %s properties", this.propertiesCount);
            }
            if (!CollectionUtils.isEmpty(this.requiredProperties)) {
                description = this.requiredProperties.size() == 1 ? description + String.format(" where %sis mandatory", this.requiredProperties.iterator().next()) : description + String.format(" where %s are mandatory", StringUtils.collectionToDelimitedString(this.requiredProperties, (String)", "));
            }
            if (this.additionalProperties instanceof Boolean) {
                description = description + ((Boolean)this.additionalProperties != false ? " " : " not ") + "allowing additional properties";
            }
            if (!CollectionUtils.isEmpty(this.properties)) {
                description = description + String.format(" defining restrictions for %s", StringUtils.collectionToDelimitedString((Collection)this.properties.stream().map(JsonSchemaProperty::getIdentifier).collect(Collectors.toList()), (String)", "));
            }
            if (!CollectionUtils.isEmpty(this.patternProperties)) {
                description = description + String.format(" defining restrictions for patterns %s", StringUtils.collectionToDelimitedString((Collection)this.patternProperties.stream().map(JsonSchemaProperty::getIdentifier).collect(Collectors.toList()), (String)", "));
            }
            return description + ".";
        }
    }
}

