/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, @Nullable String countQueryString, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        this(method, em, method.getRequiredAnnotatedQuery(), countQueryString, queryRewriter, valueExpressionDelegate);
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        super(method, em, queryString, countQueryString, queryRewriter, valueExpressionDelegate);
        this.validateQuery(this.getQuery().getQueryString(), "Validation failed for query for method %s", new Object[]{method});
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s", new Object[]{method}), new Object[0]);
        }
    }

    private void validateQuery(String query, String errorMessage, Object ... arguments) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        try (EntityManager validatingEm = null;){
            try {
                validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
                validatingEm.createQuery(query);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format(errorMessage, arguments), e);
            }
        }
    }
}

