/*
 * Copyright 2011-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mapping;

/**
 * Callback interface to implement functionality to be applied to a collection of {@link Association}s.
 *
 * @author Jon Brisbin
 * @author Oliver Gierke
 */
public interface AssociationHandler<P extends PersistentProperty<P>> {

	/**
	 * Processes the given {@link Association}.
	 *
	 * @param association
	 */
	void doWithAssociation(Association<P> association);
}
