/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.converter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.cql.converter.AbstractResultSetConverter;
import org.springframework.util.StringUtils;

public class ResultSetToListOfStringConverter
extends AbstractResultSetConverter<List<String>> {
    public static final ResultSetToListOfStringConverter INSTANCE = new ResultSetToListOfStringConverter();

    @Override
    protected List<String> doConvertSingleValue(Object object) {
        return Collections.singletonList(object.toString());
    }

    @Override
    protected List<String> doConvertSingleRow(Map<String, Object> row) {
        return row.values().stream().map(value -> value == null ? null : value.toString()).collect(Collectors.toList());
    }

    @Override
    protected List<String> doConvertResultSet(List<Map<String, Object>> resultSet) {
        return resultSet.stream().map(row -> this.doConvertSingleRow((Map)row).toArray()).map(StringUtils::arrayToCommaDelimitedString).collect(Collectors.toList());
    }

    @Override
    protected Class<?> getType() {
        return List.class;
    }
}

