/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;

class ConversionServiceDeducer {
    private final ApplicationContext applicationContext;

    ConversionServiceDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    List<ConversionService> getConversionServices() {
        if (this.hasUserDefinedConfigurationServiceBean()) {
            return Collections.singletonList((ConversionService)this.applicationContext.getBean("conversionService", ConversionService.class));
        }
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return this.getConversionServices(configurableContext);
        }
        return null;
    }

    private List<ConversionService> getConversionServices(ConfigurableApplicationContext applicationContext) {
        ArrayList<ConversionService> conversionServices = new ArrayList<ConversionService>();
        ConverterBeans converterBeans = new ConverterBeans(applicationContext);
        if (!converterBeans.isEmpty()) {
            FormattingConversionService beansConverterService = new FormattingConversionService();
            DefaultConversionService.addCollectionConverters((ConverterRegistry)beansConverterService);
            converterBeans.addTo((FormatterRegistry)beansConverterService);
            conversionServices.add((ConversionService)beansConverterService);
        }
        if (applicationContext.getBeanFactory().getConversionService() != null) {
            conversionServices.add(applicationContext.getBeanFactory().getConversionService());
        }
        if (!converterBeans.isEmpty()) {
            conversionServices.add(ApplicationConversionService.getSharedInstance());
        }
        return conversionServices;
    }

    private boolean hasUserDefinedConfigurationServiceBean() {
        String beanName = "conversionService";
        return this.applicationContext.containsBean(beanName) && this.applicationContext.getAutowireCapableBeanFactory().isTypeMatch(beanName, ConversionService.class);
    }

    private static class ConverterBeans {
        private final List<Converter> converters;
        private final List<GenericConverter> genericConverters;
        private final List<Formatter> formatters;

        ConverterBeans(ConfigurableApplicationContext applicationContext) {
            ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
            this.converters = this.beans(Converter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding", (ListableBeanFactory)beanFactory);
            this.genericConverters = this.beans(GenericConverter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding", (ListableBeanFactory)beanFactory);
            this.formatters = this.beans(Formatter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding", (ListableBeanFactory)beanFactory);
        }

        private <T> List<T> beans(Class<T> type, String qualifier, ListableBeanFactory beanFactory) {
            return new ArrayList(BeanFactoryAnnotationUtils.qualifiedBeansOfType((ListableBeanFactory)beanFactory, type, (String)qualifier).values());
        }

        boolean isEmpty() {
            return this.converters.isEmpty() && this.genericConverters.isEmpty() && this.formatters.isEmpty();
        }

        void addTo(FormatterRegistry registry) {
            for (Converter converter : this.converters) {
                registry.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                registry.addConverter(genericConverter);
            }
            for (Formatter formatter : this.formatters) {
                registry.addFormatter(formatter);
            }
        }
    }
}

