/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.elasticsearch;

import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.web.reactive.function.client.WebClient;

abstract class ElasticsearchDataConfiguration {
    ElasticsearchDataConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class, ReactiveElasticsearchOperations.class})
    static class ReactiveRestClientConfiguration {
        ReactiveRestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveElasticsearchOperations.class}, name={"reactiveElasticsearchTemplate"})
        @ConditionalOnBean(value={ReactiveElasticsearchClient.class})
        ReactiveElasticsearchTemplate reactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter, ResultsMapper resultsMapper) {
            ReactiveElasticsearchTemplate template = new ReactiveElasticsearchTemplate(client, converter, resultsMapper);
            template.setIndicesOptions(IndicesOptions.strictExpandOpenAndForbidClosed());
            template.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            return template;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Client.class})
    static class TransportClientConfiguration {
        TransportClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchOperations.class}, name={"elasticsearchTemplate"})
        @ConditionalOnBean(value={Client.class})
        ElasticsearchTemplate elasticsearchTemplate(Client client, ElasticsearchConverter converter, ResultsMapper resultsMapper) {
            try {
                return new ElasticsearchTemplate(client, converter, resultsMapper);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestHighLevelClient.class})
    static class RestClientConfiguration {
        RestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchOperations.class}, name={"elasticsearchTemplate"})
        @ConditionalOnBean(value={RestHighLevelClient.class})
        ElasticsearchRestTemplate elasticsearchTemplate(RestHighLevelClient client, ElasticsearchConverter converter, ResultsMapper resultsMapper) {
            return new ElasticsearchRestTemplate(client, converter, resultsMapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class BaseConfiguration {
        BaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchConverter elasticsearchConverter(SimpleElasticsearchMappingContext mappingContext) {
            return new MappingElasticsearchConverter((MappingContext)mappingContext);
        }

        @Bean
        @ConditionalOnMissingBean
        SimpleElasticsearchMappingContext mappingContext() {
            return new SimpleElasticsearchMappingContext();
        }

        @Bean
        @ConditionalOnMissingBean
        EntityMapper entityMapper(SimpleElasticsearchMappingContext mappingContext) {
            return new DefaultEntityMapper((MappingContext)mappingContext);
        }

        @Bean
        @ConditionalOnMissingBean
        ResultsMapper resultsMapper(SimpleElasticsearchMappingContext mappingContext, EntityMapper entityMapper) {
            return new DefaultResultMapper((MappingContext)mappingContext, entityMapper);
        }
    }
}

