/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.builtin.StandardPluginCandidate;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.metadata.Container;
import org.spongepowered.plugin.metadata.PluginMetadata;

public abstract class JVMPluginLanguageService
implements PluginLanguageService<JVMPluginResource> {
    private final Logger logger = LogManager.getLogger((String)this.name());

    @Override
    public void initialize(Environment environment) {
    }

    @Override
    public final List<PluginCandidate<JVMPluginResource>> createPluginCandidates(Environment environment, JVMPluginResource resource) throws Exception {
        Objects.requireNonNull(environment, "environment");
        Objects.requireNonNull(resource, "resource");
        String metadataPath = environment.blackboard().get(JVMKeys.METADATA_FILE_PATH);
        LinkedList<PluginCandidate<JVMPluginResource>> candidates = new LinkedList<PluginCandidate<JVMPluginResource>>();
        try (InputStream stream = this.getFileAsStream(resource.path(), metadataPath);){
            Container container = this.loadMetadataContainer(environment, stream);
            if (!container.loader().name().equals(this.name())) {
                throw new IOException(String.format("Attempt made to load Container in path '%s' with loader '%s' yet it requires '%s'!", resource.path(), this.name(), container.loader().name()));
            }
            if (!this.isValidContainer(environment, container)) {
                this.logger.debug("Container in path '{}' with loader '{}' is not valid, skipping...", (Object)resource.path(), (Object)container.loader().name());
            } else {
                boolean containerHasMetadata = false;
                for (PluginMetadata metadata : container.metadata()) {
                    if (!this.isValidMetadata(environment, metadata)) {
                        this.logger.debug("PluginMetadata '{}' within Container in path '{}' with loader '{}' is not valid, skipping...", (Object)metadata.id(), (Object)resource.path(), (Object)container.loader().name());
                        continue;
                    }
                    containerHasMetadata = true;
                    candidates.add(new StandardPluginCandidate<JVMPluginResource>(metadata, resource));
                }
                if (!containerHasMetadata) {
                    this.logger.debug("Container in path '{}' with loader '{}' has no plugin metadata, skipping...", (Object)resource.path(), (Object)container.loader().name());
                }
            }
        }
        return candidates;
    }

    public abstract Container loadMetadataContainer(Environment var1, InputStream var2) throws Exception;

    private boolean isValidContainer(Environment environment, Container container) {
        return true;
    }

    protected boolean isValidMetadata(Environment environment, PluginMetadata metadata) {
        return true;
    }

    private InputStream getFileAsStream(Path rootDirectory, String relativePath) throws URISyntaxException, IOException {
        URI uri = rootDirectory.toUri();
        Path jarFile = null;
        if (uri.getRawSchemeSpecificPart().contains("!")) {
            jarFile = Paths.get(new URI(uri.getRawSchemeSpecificPart().split("!")[0]));
        } else if (rootDirectory.toString().endsWith(".jar")) {
            jarFile = rootDirectory;
        }
        if (jarFile != null) {
            JarFile jf = new JarFile(jarFile.toFile());
            JarEntry entry = jf.getJarEntry(relativePath);
            return jf.getInputStream(entry);
        }
        return Files.newInputStream(rootDirectory.resolve(relativePath), new OpenOption[0]);
    }
}

